from fielddisplay import fielddisplay
from EnumDefinitions import *
from checkfield import *
from WriteData import *

class mask(object):
	"""
	MASK class definition

	   Usage:
	      mask=mask();
	"""

	def __init__(self): # {{{
		self.ice_levelset         = float('NaN')
		self.groundedice_levelset = float('NaN')

		#set defaults
		self.setdefaultparameters()

		#}}}
	def __repr__(self): # {{{
		string="   masks:"

		string="%s\n%s"%(string,fielddisplay(self,"groundedice_levelset","is ice grounded ? grounded ice if > 0, grounding line position if = 0, floating ice if < 0"))
		string="%s\n%s"%(string,fielddisplay(self,"ice_levelset","presence of ice if > 0, icefront position if = 0, no ice if < 0"))
		return string
		#}}}
	def setdefaultparameters(self): # {{{
		return self
	#}}}
	def checkconsistency(self,md,solution,analyses):    # {{{

		md = checkfield(md,'fieldname','mask.ice_levelset'        ,'size',[md.mesh.numberofvertices])
		isice=numpy.array(md.mask.ice_levelset>0,int)
		totallyicefree=(numpy.sum(isice[md.mesh.elements-1],axis=1)==0).astype(int)
		if any(totallyicefree):
			raise TypeError("elements with no ice not implemented yet, each element should have at least one vertex with md.mask.ice_levelset > 0")

		return md
	# }}}
	def marshall(self,md,fid):    # {{{
		WriteData(fid,'object',self,'fieldname','groundedice_levelset','format','DoubleMat','mattype',1)
		WriteData(fid,'object',self,'fieldname','ice_levelset','format','DoubleMat','mattype',1)
	# }}}
