function converged=convergence(K_ff,p_f,u_f,u_f_old,params)

%Get convergence options
debug=params.debug;
yts=params.yts;
eps_res=params.eps_res;
eps_rel=params.eps_rel;
eps_abs=params.eps_abs;

%initialization
converged=0;
displaystring(debug,' ');

%Display solver caracteristics
if (debug>1),
	solver_res=norm(K_ff*u_f-p_f,2)/norm(p_f,2);
	displaystring(debug>1,'%s%g','      condition number of stiffness matrix: ',condest(K_ff));
	displaystring(debug>1,'%s%g','      solver residue: norm(K[n]U[n]-F)/norm(F)',solver_res);
end

%Force equilibrium (Mandatory)
res=norm(K_ff*u_f_old-p_f,2)/norm(p_f,2);
if isnan(res),
	error('convergence error message: mechanical equilibrium convergence criterion is NaN!'); 
end
if (res<=eps_res),
	displaystring(debug,'%-60s%g%s%g%s','      mechanical equilibrium convergence criterion',res*100,' < ',eps_res*100,' %');
	converged=1;
else
	displaystring(debug,'%-60s%g%s%g%s','      mechanical equilibrium convergence criterion',res*100,' > ',eps_res*100,' %');
	converged=1; %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%ATTTENETIONHiohfiow 
end

%Relative criterion (optional)
if ~isnan(eps_rel),

	duf=u_f-u_f_old;
	ndu=norm(duf,2); 
	nu=norm(u_f,2); 
	if isnan(ndu),
		error('convergence error message: relative convergence criterion is NaN!'); 
	end

	if (ndu/nu<=eps_rel),
		displaystring(debug,'%-60s%g%s%g%s','      relative convergence criterion: norm(du)/norm(u)',ndu/nu*100,' < ',eps_rel*100,' %');
		converged=1;
	else
		displaystring(debug,'%-60s%g%s%g%s','      relative convergence criterion: norm(du)/norm(u)',ndu/nu*100,' > ',eps_rel*100,' %');
		converged=0;
	end

end

%Absolute criterion (optional)
if ~isnan(eps_abs),

	nduinf=norm(duf,inf)*yts; 
	if isnan(nduinf),
		error('convergence error message: absolute convergence criterion is NaN!'); 
	end

	if (nduinf<=eps_abs),
		displaystring(debug,'%-60s%g%s%g%s','      absolute convergence criterion: max(du)',nduinf,' < ',eps_abs,' m/yr');
	else
		displaystring(debug,'%-60s%g%s%g%s','      absolute convergence criterion: max(du)',nduinf,' > ',eps_abs,' m/yr');
		converged=0;
	end

end
