/*!\file GaussSeg.h
 * \brief: header file for node object
 */

#ifndef _GAUSSSEG_H_
#define _GAUSSSEG_H_

/*Headers:*/
#include "../../shared/Numerics/types.h"
#include "./Gauss.h"

class GaussSeg: public Gauss{

	private:
		int numgauss;
		IssmDouble* weights;
		IssmDouble* coords1;

	public:
		IssmDouble weight;
		IssmDouble coord1;

	public:

		/*GaussSeg constructors, destructors*/
		GaussSeg(int order);
		~GaussSeg();

		/*Methods*/
		int  begin(void);
		int  end(void);
		void Echo(void);
		int  Enum(void);
		void GaussPoint(int ig);
		void GaussVertex(int iv);
		void GaussNode(int finitelement,int iv);
};
#endif
