/*! \file ExtrudeFromBaseAnalysis.h 
 *  \brief: header file for generic external result object
 */

#ifndef _ExtrudeFromBaseAnalysis_
#define _ExtrudeFromBaseAnalysis_

/*Headers*/
#include "./Analysis.h"

class ExtrudeFromBaseAnalysis: public Analysis{

	public:
		int  DofsPerNode(int** doflist,int meshtype,int approximation);
		void UpdateParameters(Parameters* parameters,IoModel* iomodel,int solution_enum,int analysis_enum);
		void UpdateElements(Elements* elements,IoModel* iomodel,int analysis_counter,int analysis_type);
		void CreateNodes(Nodes* nodes,IoModel* iomodel);
		void CreateConstraints(Constraints* constraints,IoModel* iomodel);
		void CreateLoads(Loads* loads, IoModel* iomodel);
		void GetSolutionFromInputs(Vector<IssmDouble>* solution,Element* element);
};
#endif
