function [u_g varargout]=diagnostic_core_nonlinear(m,inputs,analysis_type,sub_analysis_type)
%INPUT function [ru_g varargout]=cielodiagnostic_core_nonlinear(m,inputs)
	
%   first off! We are going to modify the loads dataset. We need to shield the loads from those changes once we return;
	loads=m.loads;

%	stiffness and load generation only:
	m.parameters.kflag=1; m.parameters.pflag=1;

%   initialize solution vector
	count=1;
	converged=0;

	soln(count).u_g=get(inputs,'velocity',[1 1 (m.parameters.numberofdofspernode>=3) (m.parameters.numberofdofspernode>=3)]); %only keep vz if running with more than 3 dofs per node
	soln(count).u_f= Reducevectorgtof(soln(count).u_g,m.nodesets);

	displaystring(m.parameters.debug,'\n%s',['   starting direct shooting method']);
	while(~converged),
		
		%add velocity to inputs
		inputs=add(inputs,'velocity',soln(count).u_g,'doublevec',m.parameters.numberofdofspernode,m.parameters.numberofnodes);
		if count>1,
			inputs=add(inputs,'old_velocity',soln(count-1).u_g,'doublevec',m.parameters.numberofdofspernode,m.parameters.numberofnodes);
		else
			inputs=add(inputs,'old_velocity',soln(count).u_g,'doublevec',m.parameters.numberofdofspernode,m.parameters.numberofnodes);
		end

		%Update inputs in datasets
		[m.elements,m.nodes, loads,m.materials]=UpdateFromInputs(m.elements,m.nodes, loads,m.materials,inputs);
		
		%system matrices 
		[K_gg_nopenalty , p_g_nopenalty]=SystemMatrices(m.elements,m.nodes,loads,m.materials,m.parameters,inputs,analysis_type,sub_analysis_type);
		
		%penalties
		[K_gg , p_g, kmax]=PenaltySystemMatrices(K_gg_nopenalty,p_g_nopenalty,m.elements,m.nodes,loads,m.materials,m.parameters,inputs,analysis_type,sub_analysis_type);


		%Reduce tangent matrix from g size to f size
		[K_ff, K_fs] = Reducematrixfromgtof( K_gg, m.Gmn, m.nodesets); 

		%Reduce load from g size to f size
		[p_f] = Reduceloadfromgtof( p_g, m.Gmn, K_fs, m.ys, m.nodesets);

		%Increment index
		count=count+1;

		%Solve	
		displaystring(m.parameters.debug>1,'%s%g','      condition number of stiffness matrix: ',condest(K_ff));
		[soln(count).u_f]=Solver(K_ff,p_f,[],m.parameters);

		%Merge back to g set
		[soln(count).u_g]= Mergesolutionfromftog( soln(count).u_f, m.Gmn, m.ys, m.nodesets ); 

		%Deal with penalty loads
		inputs=add(inputs,'velocity',soln(count).u_g,'doublevec',m.parameters.numberofdofspernode,m.parameters.numberofnodes);
	
		%penalty constraints
		[loads,constraints_converged,num_unstable_constraints] =PenaltyConstraints( m.elements,m.nodes, loads, m.materials,m.parameters,inputs,analysis_type,sub_analysis_type);

		%Figure out if convergence have been reached

		%Solver
		solver_residue=norm(K_ff*soln(count).u_f-p_f,2)/norm(p_f,2);
		displaystring(m.parameters.debug>1,'%-60s%g','      convergence criterion: norm(K[n]U[n]-F)/norm(F)',solver_residue);

		%Force equilibrium
		res=norm(K_ff*soln(count-1).u_f-p_f,2)/norm(p_f,2);
		if (res<=m.parameters.eps_res),
			displaystring(m.parameters.debug,'%-60s%g%s%g%s','      mechanical equilibrium convergence criterion',res*100,' < ',m.parameters.eps_res*100,' %');
			converged=1;
		else
			displaystring(m.parameters.debug,'%-60s%g%s%g%s','      mechanical equilibrium convergence criterion',res*100,' > ',m.parameters.eps_res*100,' %');
			converged=1; %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%ATTTENETIONHiohfiow 
		end

		%Relative criterion
		dug=soln(count).u_g-soln(count-1).u_g; 
		ndu=norm(dug,2); 
		nu=norm(soln(count-1).u_g,2); 
		if (ndu/nu<=m.parameters.eps_rel),
			displaystring(m.parameters.debug,'%-60s%g%s%g%s','      relative convergence criterion: norm(du)/norm(u)',ndu/nu*100,' < ',m.parameters.eps_rel*100,' %');
			converged=1;
		else
			displaystring(m.parameters.debug,'%-60s%g%s%g%s','      relative convergence criterion: norm(du)/norm(u)',ndu/nu*100,' > ',m.parameters.eps_rel*100,' %');
			converged=0;
		end

		%Absolute criterion
		nduinf=norm(dug,inf)*m.parameters.yts; 
		if ~isnan(m.parameters.eps_abs),
			if (nduinf<=m.parameters.eps_abs),
				displaystring(m.parameters.debug,'%-60s%g%s%g%s','      absolute convergence criterion: max(du)',nduinf,' < ',m.parameters.eps_abs,' m/yr');
			else
				displaystring(m.parameters.debug,'%-60s%g%s%g%s','      absolute convergence criterion: max(du)',nduinf,' > ',m.parameters.eps_abs,' m/yr');
				converged=0;
			end
		end
		disp(' ')

		%rift convergence criterion
		if ~constraints_converged,
			converged=0;
		end
	end
			
	%some cleanup
	u_g=soln(count).u_g;
	clear soln

	%more output might be needed, when running in cielocontrol.m
	nout=max(nargout,1)-1;
	if nout==2,
		inputs=add(inputs,'velocity',u_g,'doublevec',m.parameters.numberofdofspernode,m.parameters.numberofnodes);
		m.parameters.kflag=1; m.parameters.pflag=0; 
		[K_gg, p_g]=SystemMatrices(m.elements,m.nodes,loads,m.materials,m.parameters,inputs,analysis_type,sub_analysis_type);
		[K_ff, K_fs] = Reducematrixfromgtof( K_gg, m.Gmn, m.nodesets); 
		varargout(1)={K_ff};
		varargout(2)={K_fs};
	end
end
