/*! \file issm.h: 
 *  \brief header file for all the ISSM library. 
 *  This header file should be included for the parallel binaries, or any 
 *  matlab mex module.
 */

#ifndef _ISSM_H_
#define _ISSM_H_

#include "DataSet/DataSet.h"
#include "io/io.h"
#include "EnumDefinitions/EnumDefinitions.h"
#include "toolkits/toolkits.h"
#include "objects/objects.h"
#include "shared/shared.h"
#include "include/macros.h"
#include "include/globals.h"

/*Modules: */
#include "./ModelProcessorx/Model.h"
#include "./Dofx/Dofx.h"
#include "./Dux/Dux.h"
#include "./SpcNodesx/SpcNodesx.h"
#include "./MpcNodesx/MpcNodesx.h"
#include "./ContourToMeshx/ContourToMeshx.h"
#include "./ContourToNodesx/ContourToNodesx.h"
#include "./InterpFromGridx/InterpFromGridx.h"
#include "./InterpFromMesh2dx/InterpFromMesh2dx.h"
#include "./InterpFromMesh3dx/InterpFromMesh3dx.h"
#include "./HoleFillerx/HoleFillerx.h"
#include "./MeshPartitionx/MeshPartitionx.h"
#include "./BuildNodeSetsx/BuildNodeSetsx.h"
#include "./Reducevectorgtosx/Reducevectorgtosx.h"
#include "./Reducevectorgtofx/Reducevectorgtofx.h"
#include "./NormalizeConstraintsx/NormalizeConstraintsx.h"
#include "./ConfigureObjectsx/ConfigureObjectsx.h"
#include "./SystemMatricesx/SystemMatricesx.h"
#include "./UpdateFromInputsx/UpdateFromInputsx.h"
#include "./UpdateGeometryx/UpdateGeometryx.h"
#include "./UpdateNodePositionsx/UpdateNodePositionsx.h"
#include "./PenaltySystemMatricesx/PenaltySystemMatricesx.h"
#include "./Reducematrixfromgtofx/Reducematrixfromgtofx.h"
#include "./Reduceloadfromgtofx/Reduceloadfromgtofx.h"
#include "./Solverx/Solverx.h"
#include "./Mergesolutionfromftogx/Mergesolutionfromftogx.h"
#include "./PenaltyConstraintsx/PenaltyConstraintsx.h"
#include "./ProcessParamsx/ProcessParamsx.h"
#include "./Gradjx/Gradjx.h"
#include "./Orthx/Orthx.h"
#include "./Misfitx/Misfitx.h"
#include "./ControlConstrainx/ControlConstrainx.h"
#include "./FieldDepthAveragex/FieldDepthAveragex.h"
#include "./GriddataMeshToGridx/GriddataMeshToGridx.h"
#include "./ComputePressurex/ComputePressurex.h"
#include "./FieldExtrudex/FieldExtrudex.h"
#include "./Qmux/Qmux.h"
#include "./NodeConnectivityx/NodeConnectivityx.h"
#include "./ElementConnectivityx/ElementConnectivityx.h"


#endif
