/*!\file Reducevectorgtofx
 * \brief reduce petsc vector from g set to s set (free dofs), using the nodeset partitioning 
 * vectors.
 */

#include "./Reducevectorgtofx.h"

#undef __FUNCT__ 
#define __FUNCT__ "Reducevectorgtofx"

void Reducevectorgtofx(Vec* puf, Vec ug, NodeSets* nodesets){

	/*output: */
	Vec uf=NULL;

	/*intermediary: */
	Vec un=NULL;

	if(nodesets){


		if (nodesets->GetNSize() && nodesets->GetFSize()){

			VecPartition(&un,ug,nodesets->GetPV_N(),nodesets->GetNSize());
		
			VecPartition(&uf,un,nodesets->GetPV_F(),nodesets->GetFSize());
		
		}

		/*Free ressources:*/
		VecFree(&un);
	}
	
	/*Assign output pointers:*/
	*puf=uf;
}
