/*!\file DoubleParam.c
 * \brief: implementation of the DoubleParam object
 */

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../classes.h"
#include "shared/shared.h"

/*DoubleParam constructors and destructor*/
/*FUNCTION DoubleParam::DoubleParam(){{{*/
DoubleParam::DoubleParam(){
	return;
}
/*}}}*/
/*FUNCTION DoubleParam::DoubleParam(int enum_type,IssmDouble value){{{*/
DoubleParam::DoubleParam(int in_enum_type,IssmDouble in_value){

	enum_type=in_enum_type;
	value=in_value;
}
/*}}}*/
/*FUNCTION DoubleParam::~DoubleParam(){{{*/
DoubleParam::~DoubleParam(){
	return;
}
/*}}}*/

/*Object virtual functions definitions:*/
/*FUNCTION DoubleParam::Echo {{{*/
void DoubleParam::Echo(void){
	this->DeepEcho();
}
/*}}}*/
/*FUNCTION DoubleParam::DeepEcho{{{*/
void DoubleParam::DeepEcho(void){

	_printf_(setw(22)<<"   DoubleParam "<<setw(35)<<left<<EnumToStringx(this->enum_type)<<" "<<this->value<<"\n");
}
/*}}}*/
/*FUNCTION DoubleParam::Id{{{*/
int    DoubleParam::Id(void){ return -1; }
/*}}}*/
/*FUNCTION DoubleParam::ObjectEnum{{{*/
int DoubleParam::ObjectEnum(void){

	return DoubleParamEnum;

}
/*}}}*/
/*FUNCTION DoubleParam::copy{{{*/
Object* DoubleParam::copy() {

	return new DoubleParam(this->enum_type,this->value);

}
/*}}}*/

/*DoubleParam virtual functions definitions: */
/*FUNCTION DoubleParam::GetParameterValue(int* pinteger){{{*/
void DoubleParam::GetParameterValue(int* pinteger){
	_error_("Double param of enum " << enum_type << " (" << EnumToStringx(enum_type) << ") cannot return an integer");
}
/*}}}*/
/*FUNCTION DoubleParam::GetParameterValue(bool* pbool){{{*/
void DoubleParam::GetParameterValue(bool* pbool){
	_error_("Double param of enum " << enum_type << " (" << EnumToStringx(enum_type) << ") cannot return an bool");
}
/*}}}*/
/*FUNCTION DoubleParam::GetParameterValue(int** pintarray,int* pM){{{*/
void DoubleParam::GetParameterValue(int** pintarray,int* pM){
	_error_("Double param of enum " << enum_type << " (" << EnumToStringx(enum_type) << ") cannot return an array of integers");
}
/*}}}*/
/*FUNCTION DoubleParam::GetParameterValue(int** pintarray,int* pM,int* pN){{{*/
void DoubleParam::GetParameterValue(int** pintarray,int* pM,int* pN){
	_error_("Double param of enum " << enum_type << " (" << EnumToStringx(enum_type) << ") cannot return an array of integers");
}
/*}}}*/
/*FUNCTION DoubleParam::GetParameterValue(IssmDouble** pIssmDoublearray,int* pM){{{*/
void DoubleParam::GetParameterValue(IssmDouble** pIssmDoublearray,int* pM){
	_error_("Double param of enum " << enum_type << " (" << EnumToStringx(enum_type) << ") cannot return an array of IssmDouble");
}
/*}}}*/
/*FUNCTION DoubleParam::GetParameterValue(IssmDouble** pIssmDoublearray,int* pM,int* pN){{{*/
void DoubleParam::GetParameterValue(IssmDouble** pIssmDoublearray,int* pM,int* pN){
	_error_("Double param of enum " << enum_type << " (" << EnumToStringx(enum_type) << ") cannot return an array of IssmDouble");
}
/*}}}*/
