/*!\file DataSetParam.c
 * \brief: implementation of the DataSetParam object
 */

/*header files: */
/*{{{*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../classes.h"
#include "shared/shared.h"
/*}}}*/

/*DataSetParam constructors and destructor*/
/*FUNCTION DataSetParam::DataSetParam(){{{*/
DataSetParam::DataSetParam(){
	value=NULL;
	return;
}
/*}}}*/
/*FUNCTION DataSetParam::DataSetParam(int enum_type,DataSet *value){{{*/
DataSetParam::DataSetParam(int in_enum_type,DataSet* in_value){

	enum_type=in_enum_type;
	value=in_value->Copy();;
}
/*}}}*/
/*FUNCTION DataSetParam::~DataSetParam(){{{*/
DataSetParam::~DataSetParam(){
	delete value;
}
/*}}}*/

/*Object virtual functions definitions:*/
/*FUNCTION DataSetParam::Echo {{{*/
void DataSetParam::Echo(void){
	this->DeepEcho();
}
/*}}}*/
/*FUNCTION DataSetParam::DeepEcho{{{*/
void DataSetParam::DeepEcho(void){

	_printf_(setw(22)<<"   DataSetParam "<<setw(35)<<left<<EnumToStringx(this->enum_type)<<" ----- begin\n");
	this->value->Echo();
	_printf_(setw(22)<<"   DataSetParam "<<setw(35)<<left<<EnumToStringx(this->enum_type)<<" ----- end\n");
}
/*}}}*/
/*FUNCTION DataSetParam::Id{{{*/
int    DataSetParam::Id(void){ return -1; }
/*}}}*/
/*FUNCTION DataSetParam::ObjectEnum{{{*/
int DataSetParam::ObjectEnum(void){

	return DataSetParamEnum;

}
/*}}}*/
/*FUNCTION DataSetParam::copy{{{*/
Object* DataSetParam::copy() {

	return new DataSetParam(this->enum_type,this->value);

}
/*}}}*/

/*DataSetParam virtual functions definitions: */
/*FUNCTION DataSetParam::GetParameterValue{{{*/
void DataSetParam::GetParameterValue(DataSet** pdataset){
	*pdataset=value->Copy();
}
/*}}}*/
