/*!\file: matrix.h
 * \brief prototypes for matrix.h
 */ 

#ifndef _MATRIXUTILS_H_
#define _MATRIXUTILS_H_

#include "../Numerics/types.h"

int  TripleMultiply( IssmDouble* a, int nrowa, int ncola, int itrna, IssmDouble* b, int nrowb, int ncolb, int itrnb, IssmDouble* c, int nrowc, int ncolc, int itrnc, IssmDouble* d, int iaddd);
int  MatrixMultiply( IssmDouble* a, int nrowa, int ncola, int itrna, IssmDouble* b, int nrowb, int ncolb, int itrnb, IssmDouble* c, int iaddc );
int  MatrixInverse( IssmDouble* a, int ndim, int nrow, IssmDouble* b, int nvec, IssmDouble* pdet );
void Matrix2x2Invert(IssmDouble* Ainv, IssmDouble* A);
void Matrix2x2Determinant(IssmDouble* Adet,IssmDouble* A);
void Matrix3x3Invert(IssmDouble* Ainv, IssmDouble* A);
void Matrix3x3Determinant(IssmDouble* Adet,IssmDouble* A);

#endif //ifndef _MATRIXUTILS_H_
