/*!\file: extrudefrombase_core.cpp
 * \brief: core of the extrusion solution
 */ 

#include "./cores.h"
#include "../toolkits/toolkits.h"
#include "../classes/classes.h"
#include "../shared/shared.h"
#include "../solutionsequences/solutionsequences.h"
#include "../modules/modules.h"

void extrudefrombase_core(FemModel* femmodel){

	if(VerboseSolution()) _printf0_("extruding solution from base...\n");

	/*Call on core computations: */
	femmodel->SetCurrentConfiguration(ExtrudeFromBaseAnalysisEnum);
	femmodel->UpdateConstraintsExtrudeFromBasex();
	solutionsequence_linear(femmodel);

}
