function [inputs model]=ControlInitialization(models,inputs);

%recover models
m_dh=models.dh;
m_dv=models.dv;
m_ds=models.ds;
m_dhu=models.dhu;
m_sl=models.sl;

%recover parameters common to all solutions
debug=m_dhu.parameters.debug;
dim=m_dhu.parameters.dim;
ishutter=m_dhu.parameters.ishutter;
ismacayealpattyn=m_dh.parameters.ismacayealpattyn;
isstokes=m_ds.parameters.isstokes;

%If Pattyn or MacAyeal, just return, no initialization needed
if ~isstokes
	model=m_dh;
	return
end

%1: Get slopes once for all

%compute slopes
displaystring(debug,'\n%s',['computing bed slope (x and y derivatives)...']);
slopex=diagnostic_core_linear(m_sl,inputs,SlopeComputeAnalysisEnum(),BedXAnalysisEnum());
slopey=diagnostic_core_linear(m_sl,inputs,SlopeComputeAnalysisEnum(),BedYAnalysisEnum());
slopex=FieldExtrude(m_sl.elements,m_sl.nodes,m_sl.loads,m_sl.materials,slopex,'slopex',0);
slopey=FieldExtrude(m_sl.elements,m_sl.nodes,m_sl.loads,m_sl.materials,slopey,'slopey',0);

%Add to inputs
inputs=add(inputs,'bedslopex',slopex,'doublevec',m_sl.parameters.numberofdofspernode,m_sl.parameters.numberofnodes);
inputs=add(inputs,'bedslopey',slopey,'doublevec',m_sl.parameters.numberofdofspernode,m_sl.parameters.numberofnodes);

%2: update spcs using MacAyeal or Pattyn

%horizontal velocities
displaystring(debug,'\n%s',['computing horizontal velocities...']);
u_g=diagnostic_core_nonlinear(m_dh,inputs,'diagnostic','horiz');
displaystring(debug,'\n%s',['extruding horizontal velocities...']);
u_g_horiz=FieldExtrude(m_dh.elements,m_dh.nodes,m_dh.loads,m_dh.materials,u_g,'velocity',1);

%vertical velocities
displaystring(debug,'\n%s',['computing vertical velocities...']);
inputs=add(inputs,'velocity',u_g_horiz,'doublevec',m_dh.parameters.numberofdofspernode,m_dh.parameters.numberofnodes);
u_g_vert=diagnostic_core_linear(m_dv,inputs,'diagnostic','vert');

%create 3d u_g
displaystring(debug,'\n%s',['combining horizontal and vertical velocities...']);
u_g=zeros(m_dh.parameters.numberofnodes*3,1);
u_g(dofsetgen([1,2],3,m_dh.parameters.numberofnodes*3))=u_g_horiz;
u_g(dofsetgen([3],3,m_dh.parameters.numberofnodes*3))=u_g_vert;

% get pressure (reconditionned) and create 4d u_g
displaystring(debug,'\n%s',['computing pressure according to Pattyn...']);
p_g=ComputePressure(m_dh.elements,m_dh.nodes,m_dh.loads,m_dh.materials,m_dh.parameters,inputs);
p_g=p_g/m_ds.parameters.stokesreconditioning;
u_g_stokes=zeros(m_ds.nodesets.gsize,1);
u_g_stokes(dofsetgen([1,2,3],4,m_ds.nodesets.gsize))=u_g;
u_g_stokes(dofsetgen([4],4,m_ds.nodesets.gsize))=p_g;
inputs=add(inputs,'velocity',u_g_stokes,'doublevec',4,m_ds.parameters.numberofnodes);

%update BC (spcs)
displaystring(debug,'\n%s',['update boundary conditions for stokes using velocities previously computed...']);
m_ds.y_g=zeros(m_ds.nodesets.gsize,1);
m_ds.y_g(dofsetgen([1,2,3],4,m_ds.nodesets.gsize))=u_g;
[m_ds.ys m_ds.ys0]=Reducevectorgtos(m_ds.y_g,m_ds.nodesets);

%Compute Stokes velocities once to have a reasonably good ug in input
displaystring(debug,'\n%s',['computing stokes velocities and pressure ...']);
u_g=diagnostic_core_nonlinear(m_ds,inputs,'diagnostic','stokes');
inputs=add(inputs,'velocity',u_g,'doublevec',4,m_ds.parameters.numberofnodes);

%assign output
model=m_ds;
