/*!\file: CreateDataSets
 * \brief general driver for creating all datasets that make a finite element iomodel
 */ 

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../../classes/classes.h"
#include "../../shared/shared.h"
#include "../MeshPartitionx/MeshPartitionx.h"
#include "./ModelProcessorx.h"

void CreateDataSets(Elements* elements,Nodes* nodes, Vertices* vertices, Materials* materials,Constraints* constraints, Loads* loads,Parameters* parameters,IoModel* iomodel,FILE* toolkitfile,char* rootpath,const int solution_enum,const int analysis_enum,const int nummodels,int analysis_counter){

	/*Creates Nodes and constraints datasets if empty*/

	/*Now, branch onto analysis dependent model generation: */
	Analysis* analysis = EnumToAnalysis(analysis_enum);
	analysis->UpdateParameters(parameters,iomodel,solution_enum,analysis_enum);
	analysis->CreateNodes(nodes,iomodel);
	analysis->CreateConstraints(constraints,iomodel);
	analysis->CreateLoads(loads,iomodel);
	analysis->UpdateElements(elements,iomodel,analysis_counter,analysis_enum);
	delete analysis;

	/*Update Elements and Materials For Inversions*/
	#ifdef _HAVE_CONTROL_
	UpdateElementsAndMaterialsControl(elements,materials,iomodel);
	#endif

	/*Update Elements and Materials For Dakota*/
	#ifdef _HAVE_DAKOTA_
	UpdateElementsAndMaterialsDakota(elements,materials,iomodel);
	#endif

	/*Update Elements in case we are running a transient solution: */
	#ifdef _HAVE_TRANSIENT_
	if(analysis_counter==(nummodels-1)&& solution_enum==TransientSolutionEnum){
		UpdateElementsTransient(elements,parameters,iomodel,analysis_counter,analysis_enum);
	}
	#endif

	/* Update counters, because we have created more nodes, loads and
	 * constraints, and ids for objects created in next call to CreateDataSets
	 * will need to start at the end of the updated counters: */
	iomodel->nodecounter       = nodes->MaximumId();
	iomodel->loadcounter       = loads->NumberOfLoads();
	iomodel->constraintcounter = constraints->NumberOfConstraints();
}
