/*!\file: SortDataSets.cpp
 * \brief sort datasets created in CreateDataSets
 */ 

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../../classes/classes.h"
#include "../../shared/shared.h"
#include "./ModelProcessorx.h"

void SortDataSets(Elements*elements,Nodes*nodes,Vertices*vertices, Loads*loads, Materials*materials, Constraints*constraints, Parameters*parameters){

	/*All our datasets are already ordered by ids. Set presort flag so that
	 * later on, when sorting is requested on these datasets, it will not be
	 * redone: */
	elements->Presort();
	nodes->Presort();
	vertices->Presort();
	loads->Presort();
	materials->Presort();
	constraints->Presort();
	parameters->Presort();
}
