/* \file ModelProcessorx.h
 * \brief  Header file for model processor
 */

#ifndef _MODEL_PROCESSORX_H_
#define _MODEL_PROCESSORX_H_

#include "../../classes/classes.h"
#include "../../analyses/analyses.h"

void ModelProcessorx(Elements** pelements, Nodes** pnodes, Vertices** pvertices, Materials** pmaterials, Constraints** pconstraints, Loads** ploads, Parameters** pparameters, FILE* iomodel_handle,FILE* toolkitfile, char* rootpath,const int solution_type,const int nummodels,const int* analysis_type_listh);

/*Creation of fem datasets: general drivers*/
void CreateDataSets(Elements** pelements,Nodes** pnodes,Vertices** pvertices, Materials** pmaterials, Constraints** pconstraints, Loads** ploads,Parameters** pparameters,IoModel* iomodel,FILE* toolkitfile,char* rootpath,const int solution_type,int analysis_type,const int nummodels,int analysis_counter);
void CreateElementsVerticesAndMaterials(Elements** pelements,Vertices** pvertices,Materials** pmaterials, IoModel* iomodel,const int nummodels);
void CreateParameters(Parameters** pparameters,IoModel* iomodel,char* rootpath,FILE* toolkitfile,const int solution_type,int analysis_type,int analysis_counter);
void CreateParametersAutodiff(Parameters** pparameters,IoModel* iomodel,int solution_type,int analysis_type);
void CreateParametersControl(Parameters** pparameters,IoModel* iomodel,int solution_type,int analysis_type);
void CreateParametersDakota(Parameters** pparameters,IoModel* iomodel,char* rootpath,int solution_type,int analysis_type);
void CreateOutputDefinitions(Parameters** pparameters,IoModel* iomodel);
void UpdateElementsAndMaterialsControl(Elements* elements,Materials* materials, IoModel* iomodel);
void UpdateElementsAndMaterialsDakota(Elements* elements,Materials* materials, IoModel* iomodel);
void UpdateElementsTransient(Elements* elements,Parameters* parameters,IoModel* iomodel,int analysis_counter,int analysis_type);
void CreateNodes(Nodes** pnodes, IoModel* iomodel,int analysis,int finite_element,int approximation=NoneApproximationEnum);

/*partitioning: */
void ElementsAndVerticesPartitioning(bool** pmy_elements, int** pmy_vertices, IoModel* iomodel);
void NodesPartitioning(bool** pmy_nodes,bool* my_elements, int* my_vertices,  IoModel* iomodel, bool continuous);
void FacesPartitioning(bool** pmy_faces,IoModel* iomodel);
void EdgesPartitioning(bool** pmy_edges,IoModel* iomodel);

/*Mesh properties*/
void CreateFaces(IoModel* iomodel);
void CreateEdges(IoModel* iomodel);

/*Connectivity*/
void CreateSingleNodeToElementConnectivity(IoModel* iomodel);
void CreateNumberNodeToElementConnectivity(IoModel* iomodel);

/*Diverse: */
void SortDataSets(Elements** pelements,Nodes** pnodes,Vertices** pvertices, Loads** ploads, Materials** pmaterials, Constraints** pconstraints, Parameters** pparameters);
void UpdateCounters(IoModel* iomodel,Nodes** pnodes,Loads** ploads, Constraints** pconstraints);

#endif
