#include "./HydrologyDCEfficientAnalysis.h"
#include "../toolkits/toolkits.h"
#include "../classes/classes.h"
#include "../shared/shared.h"
#include "../modules/modules.h"

/*Model processing*/
int  HydrologyDCEfficientAnalysis::DofsPerNode(int** doflist,int meshtype,int approximation){/*{{{*/
	return 1;
}/*}}}*/
void HydrologyDCEfficientAnalysis::UpdateParameters(Parameters** pparameters,IoModel* iomodel,int solution_enum,int analysis_enum){/*{{{*/

	Parameters *parameters = NULL;
	int         hydrology_model;
	bool        isefficientlayer;

	/*Get parameters: */
	parameters=*pparameters;

	/*retrieve some parameters: */
	iomodel->Constant(&hydrology_model,HydrologyModelEnum);

	/*Now, do we really want DC?*/
	if(hydrology_model!=HydrologydcEnum){
		*pparameters=parameters;
		return;
	}

	/*Do we want an efficient layer*/
	iomodel->Constant(&isefficientlayer,HydrologydcIsefficientlayerEnum);
	if(!isefficientlayer){
		*pparameters=parameters;
		return;
	}

	/*Nothing for now*/

	/*Assign output pointer: */
	*pparameters=parameters;
}/*}}}*/
void HydrologyDCEfficientAnalysis::UpdateElements(Elements* elements,IoModel* iomodel,int analysis_counter,int analysis_type){/*{{{*/

	bool   isefficientlayer;
	int    hydrology_model;

	/*Now, do we really want DC?*/
	iomodel->Constant(&hydrology_model,HydrologyModelEnum);
	if(hydrology_model!=HydrologydcEnum) return;

	/*Do we want an efficient layer*/
	iomodel->Constant(&isefficientlayer,HydrologydcIsefficientlayerEnum);
	if(!isefficientlayer) return;

	/*Update elements: */
	int counter=0;
	for(int i=0;i<iomodel->numberofelements;i++){
		if(iomodel->my_elements[i]){
			Element* element=(Element*)elements->GetObjectByOffset(counter);
			element->Update(i,iomodel,analysis_counter,analysis_type,P1Enum);
			counter++;
		}
	}

	iomodel->FetchDataToInput(elements,ThicknessEnum);
	iomodel->FetchDataToInput(elements,SurfaceEnum);
	iomodel->FetchDataToInput(elements,BedEnum);
	iomodel->FetchDataToInput(elements,MaskIceLevelsetEnum);
	iomodel->FetchDataToInput(elements,MeshElementonbedEnum);
	iomodel->FetchDataToInput(elements,MeshElementonsurfaceEnum);
	iomodel->FetchDataToInput(elements,BasalforcingsMeltingRateEnum);
	iomodel->FetchDataToInput(elements,EplHeadEnum);
}/*}}}*/
void HydrologyDCEfficientAnalysis::CreateNodes(Nodes** pnodes,IoModel* iomodel){/*{{{*/

	/*Now, do we really want DC?*/
	int  hydrology_model;
	iomodel->Constant(&hydrology_model,HydrologyModelEnum);
	if(hydrology_model!=HydrologydcEnum) return;

	/*Do we want an efficient layer*/
	bool isefficientlayer;
	iomodel->Constant(&isefficientlayer,HydrologydcIsefficientlayerEnum);
	if(!isefficientlayer) return;

	iomodel->FetchData(3,MeshVertexonbedEnum,MeshVertexonsurfaceEnum,FlowequationVertexEquationEnum);
	::CreateNodes(pnodes,iomodel,HydrologyDCEfficientAnalysisEnum,P1Enum);
	iomodel->DeleteData(3,MeshVertexonbedEnum,MeshVertexonsurfaceEnum,FlowequationVertexEquationEnum);
}/*}}}*/
void HydrologyDCEfficientAnalysis::CreateConstraints(Constraints** pconstraints,IoModel* iomodel){/*{{{*/

	/*Recover pointer: */
	Constraints* constraints=*pconstraints;

	/*Do we really want DC?*/
	int  hydrology_model;
	iomodel->Constant(&hydrology_model,HydrologyModelEnum);
	if(hydrology_model!=HydrologydcEnum) return;

	/*Do we want an efficient layer*/
	bool isefficientlayer;
	iomodel->Constant(&isefficientlayer,HydrologydcIsefficientlayerEnum);
	if(!isefficientlayer) return;

	IoModelToConstraintsx(constraints,iomodel,HydrologydcSpceplHeadEnum,HydrologyDCEfficientAnalysisEnum,P1Enum);

	/*Assign output pointer: */
	*pconstraints=constraints;
}/*}}}*/
void HydrologyDCEfficientAnalysis::CreateLoads(Loads** ploads, IoModel* iomodel){/*{{{*/

	/*Recover pointer: */
	Loads* loads=*ploads;

	/*Do we really want DC?*/
	int  hydrology_model;
	iomodel->Constant(&hydrology_model,HydrologyModelEnum);
	if(hydrology_model!=HydrologydcEnum) return;

	/*Do we want an efficient layer*/
	bool isefficientlayer;
	iomodel->Constant(&isefficientlayer,HydrologydcIsefficientlayerEnum);
	if(!isefficientlayer) return;

	/*Nothing for now*/

	/*Assign output pointer: */
	*ploads=loads;
}/*}}}*/
