#include "./DamageEvolutionAnalysis.h"
#include "../toolkits/toolkits.h"
#include "../classes/classes.h"
#include "../shared/shared.h"
#include "../modules/modules.h"

/*Model processing*/
int  DamageEvolutionAnalysis::DofsPerNode(int** doflist,int meshtype,int approximation){/*{{{*/
	return 1;
}/*}}}*/
void DamageEvolutionAnalysis::UpdateParameters(Parameters** pparameters,IoModel* iomodel,int solution_enum,int analysis_enum){/*{{{*/
}/*}}}*/
void DamageEvolutionAnalysis::UpdateElements(Elements* elements,IoModel* iomodel,int analysis_counter,int analysis_type){/*{{{*/

	/*Update elements: */
	int counter=0;
	for(int i=0;i<iomodel->numberofelements;i++){
		if(iomodel->my_elements[i]){
			Element* element=(Element*)elements->GetObjectByOffset(counter);
			element->Update(i,iomodel,analysis_counter,analysis_type,P1Enum);
			counter++;
		}
	}

	/*What input do I need to run my damage evolution model?*/
	iomodel->FetchDataToInput(elements,VxEnum);
	iomodel->FetchDataToInput(elements,VyEnum);
	iomodel->FetchDataToInput(elements,VzEnum);
	iomodel->FetchDataToInput(elements,DamageDEnum);
	iomodel->FetchDataToInput(elements,MaskIceLevelsetEnum);
	iomodel->FetchDataToInput(elements,PressureEnum);

	bool dakota_analysis;
	iomodel->Constant(&dakota_analysis,QmuIsdakotaEnum);
	if(dakota_analysis){
		elements->InputDuplicate(DamageDEnum, QmuDamageDEnum);
	}
}/*}}}*/
void DamageEvolutionAnalysis::CreateNodes(Nodes** pnodes,IoModel* iomodel){/*{{{*/

	iomodel->FetchData(1,MeshVertexonbedEnum);
	::CreateNodes(pnodes,iomodel,DamageEvolutionAnalysisEnum,P1Enum);
	iomodel->DeleteData(1,MeshVertexonbedEnum);
}/*}}}*/
void DamageEvolutionAnalysis::CreateConstraints(Constraints** pconstraints,IoModel* iomodel){/*{{{*/

	/*Fetch parameters: */
	int stabilization;
	iomodel->Constant(&stabilization,DamageStabilizationEnum);

	/*Recover pointer: */
	Constraints* constraints=*pconstraints;

	IoModelToConstraintsx(constraints,iomodel,DamageSpcdamageEnum,DamageEvolutionAnalysisEnum,P1Enum);

	/*Assign output pointer: */
	*pconstraints=constraints;
}/*}}}*/
void DamageEvolutionAnalysis::CreateLoads(Loads** ploads, IoModel* iomodel){/*{{{*/

	/*Recover pointer: */
	Loads* loads=*ploads;

	/*create penalties for nodes: no node can have a damage > 1*/
	iomodel->FetchData(1,DamageSpcdamageEnum);
	CreateSingleNodeToElementConnectivity(iomodel);

	for(int i=0;i<iomodel->numberofvertices;i++){

		/*keep only this partition's nodes:*/
		if(iomodel->my_vertices[i]){
			if (xIsNan<IssmDouble>(iomodel->Data(DamageSpcdamageEnum)[i])){ //No penalty applied on spc nodes!
				loads->AddObject(new Pengrid(iomodel->loadcounter+i+1,i,iomodel,DamageEvolutionAnalysisEnum));
			}
		}
	}
	iomodel->DeleteData(1,DamageSpcdamageEnum);

	/*Assign output pointer: */
	*ploads=loads;
}/*}}}*/
