/*!\file:  Analysis.h
 * \brief abstract class for Analysis objects
 */ 

#ifndef _ANALYSIS_H_
#define _ANALYSIS_H_

class Parameters;
class IoModel;
class Elements;
class Nodes;
class Constraints;
class Loads;

class Analysis{

	public: 

		virtual      ~Analysis(){};
		virtual int  DofsPerNode(int** doflist,int meshtype,int approximation)=0;
		virtual void UpdateParameters(Parameters** pparameters,IoModel* iomodel,int solution_enum,int analysis_enum)=0;
		virtual void UpdateElements(Elements* elements,IoModel* iomodel,int analysis_counter,int analysis_type)=0;
		virtual void CreateNodes(Nodes** pnodes,IoModel* iomodel)=0;
		virtual void CreateConstraints(Constraints** pconstraints,IoModel* iomodel)=0;
		virtual void CreateLoads(Loads** ploads, IoModel* iomodel)=0;
};
#endif
