function results=control_core(models,inputs)
%CONTROL_CORE - compute the core inversion
%
%   Usage:
%      results=control_core(models,inputs);
%

%Preprocess models
[inputs model]=ControlInitialization(models,inputs);

%recover parameters common to all solutions
debug=model.parameters.debug;

%initialize control parameters
param_g=model.parameters.param_g;

%set optimization options.
options=ControlOptions(model.parameters);

for n=1:model.parameters.nsteps,

	%set options
	options=optimset(options,'MaxFunEvals',model.parameters.maxiter(n));

	disp(sprintf('\n%s%s%s%s\n',['   control method step ' num2str(n) '/' num2str(model.parameters.nsteps)]));

	%update inputs with new fit
	inputs=add(inputs,'fit',model.parameters.fit(n),'double');
	inputs=add(inputs,model.parameters.control_type,param_g,'doublevec',1,model.parameters.numberofnodes);

	%Update inputs in datasets
	[model.elements,model.nodes,model.loads,model.materials]=UpdateFromInputs(model.elements,model.nodes,model.loads,model.materials,inputs);

	displaystring(debug,'\n%s',['      computing gradJ...']);
	[u_g c(n).grad_g]=GradJCompute(model,inputs,model.parameters.analysis_type,model.parameters.sub_analysis_type);
	inputs=add(inputs,'velocity',u_g,'doublevec',2,model.parameters.numberofnodes);

	displaystring(debug,'\n%s',['      normalizing directions...']);
	if n>=2,
		c(n).grad_g=Orth(c(n).grad_g,c(n-1).grad_g);
	else
		c(n).grad_g=Orth(c(n).grad_g,{});
	end

	%visualize direction.
	if model.parameters.plot
		plot_direction;
	end

	displaystring(debug,'\n%s',['      optimizing along gradient direction...']);
	[search_scalar c(n).J]=ControlOptimization('objectivefunctionC',0,1,options,model,inputs,param_g,c(n).grad_g,n,model.parameters.analysis_type,model.parameters.sub_analysis_type);

	displaystring(debug,'\n%s',['      updating parameter using optimized search scalar...']);
	param_g=param_g+search_scalar*model.parameters.optscal(n)*c(n).grad_g;

	displaystring(debug,'\n%s',['      constraining the new distribution...']);
	param_g=ControlConstrain(param_g,model.parameters);

	%visualize direction.
	if model.parameters.plot,
		plot_newdistribution;
	end

	disp(['      value of misfit J after optimization #' num2str(n) ':' num2str(c(n).J)]);
end

%generate output
displaystring(debug,'\n%s',['      preparing final velocity solution...']);

%compute final velocity from diagnostic_core (horiz+vertical)
inputs=add(inputs,model.parameters.control_type,param_g,'doublevec',1,model.parameters.numberofnodes);
results_diag=diagnostic_core(models,inputs);

%Recover misfit at each iteration of the control method 
J=zeros(length(c),1);
for i=1:length(c),
	J(i)=c(i).J;
end

%build results
results.time=0;
results.step=1;
results.J=J;
results.param_g=param_g;
results.u_g=results_diag.u_g;
