/*!\file:  DistributeNumDofs.cpp
 * \brief: figure out the maximum number of dofs per node.
 */ 

#include "../../shared/shared.h"
#include "../../classes/classes.h"

void DistributeNumDofs(DofIndexing* index,int analysis_type,int node_type,int mesh_type){

	/*For now, we distribute by analysis_type, later, we will distribute using the analysis_type,
	 * but also the node_type: */

	int  numdofs = -1;   //default numdofs
	int *doftype = NULL;

	/*ok, according to analysis type: */
	switch(analysis_type){
		case StressbalanceAnalysisEnum:
			switch(node_type){
				case SSAApproximationEnum:
					numdofs=2;
					break;
				case L1L2ApproximationEnum:
					numdofs=2;
					break;
				case HOApproximationEnum:
					numdofs=2;
					break;
				case SIAApproximationEnum:
					numdofs=2;
					break;
				case FSvelocityEnum:
					if(mesh_type==Mesh3DEnum){
						numdofs=3;
					}
					else if(mesh_type==Mesh2DverticalEnum){
						numdofs=2;
					}
					else{
						_error_("mesh type not supported yet");
					}
					break;
				case FSpressureEnum:
					numdofs=1;
					break;
				case NoneApproximationEnum:
					if(mesh_type==Mesh3DEnum){
						numdofs=4;
					}
					else if(mesh_type==Mesh2DverticalEnum){
						numdofs=3;
					}
					else{
						_error_("mesh type not supported yet");
					}
					break;
				case SSAHOApproximationEnum:
					numdofs=4;
					doftype=xNew<int>(numdofs);
					doftype[0]=SSAApproximationEnum;
					doftype[1]=SSAApproximationEnum;
					doftype[2]=HOApproximationEnum;
					doftype[3]=HOApproximationEnum;
					break;
				case HOFSApproximationEnum:
					numdofs=5;
					doftype=xNew<int>(numdofs);
					doftype[0]=HOApproximationEnum;
					doftype[1]=HOApproximationEnum;
					doftype[2]=FSvelocityEnum;
					doftype[3]=FSvelocityEnum;
					doftype[4]=FSvelocityEnum;
					break;
				case SSAFSApproximationEnum:
					numdofs=5;
					doftype=xNew<int>(numdofs);
					doftype[0]=SSAApproximationEnum;
					doftype[1]=SSAApproximationEnum;
					doftype[2]=FSvelocityEnum;
					doftype[3]=FSvelocityEnum;
					doftype[4]=FSvelocityEnum;
					break;
				default:
					_error_("Approximationtype " << node_type << " (" << EnumToStringx(node_type) << ") not implemented yet for StressbalanceHoriz");

			}
			break;
		case StressbalanceVerticalAnalysisEnum:
			numdofs=1;
			break;
		case StressbalanceSIAAnalysisEnum:
			numdofs=2;
			break;
		case L2ProjectionBaseAnalysisEnum:
			numdofs=1;
			break;
		case L2ProjectionTopAnalysisEnum:
			numdofs=1;
			break;
		case ThermalAnalysisEnum:
			numdofs=1;
			break;
		case EnthalpyAnalysisEnum:
			numdofs=1;
			break;
		case HydrologyDCInefficientAnalysisEnum:
			numdofs=1;
			break;
		case HydrologyDCEfficientAnalysisEnum:
			numdofs=1;
			break;
		case HydrologyShreveAnalysisEnum:
			numdofs=1;
			break;
		case MeltingAnalysisEnum:
			numdofs=1;
			break;
		case MasstransportAnalysisEnum:
			numdofs=1;
			break;
		case FreeSurfaceTopAnalysisEnum:
			numdofs=1;
			break;
		case FreeSurfaceBaseAnalysisEnum:
			numdofs=1;
			break;
		case ExtrudeFromBaseAnalysisEnum:
			numdofs=1;
			break;
		case ExtrudeFromTopAnalysisEnum:
			numdofs=1;
			break;
		case GiaAnalysisEnum:
			numdofs=1;
			break;
		case DamageEvolutionAnalysisEnum:
			numdofs=1;
			break;
		case BalancethicknessAnalysisEnum:
			numdofs=1;
			break;
		case BalancevelocityAnalysisEnum:
			numdofs=1;
			break;
		default:
			_error_("analysis type: " << analysis_type << " (" << EnumToStringx(analysis_type) << ") not implemented yet");
	}

	/*Now initialize the index*/
	index->Init(numdofs,doftype);

	/*Clean up*/
	 xDelete<int>(doftype);
}
