/*! \file CreateLoadsDamage.c:
 */

#include "../../../toolkits/toolkits.h"
#include "../../../classes/classes.h"
#include "../../../shared/shared.h"
#include "../ModelProcessorx.h"

void	CreateLoadsDamage(Loads** ploads, IoModel* iomodel){

	/*Recover pointer: */
	Loads* loads=*ploads;

	/*create penalties for nodes: no node can have a damage > 1*/
	iomodel->FetchData(1,DamageSpcdamageEnum);
	CreateSingleNodeToElementConnectivity(iomodel);

	for(int i=0;i<iomodel->numberofvertices;i++){

		/*keep only this partition's nodes:*/
		if(iomodel->my_vertices[i]){
			if (xIsNan<IssmDouble>(iomodel->Data(DamageSpcdamageEnum)[i])){ //No penalty applied on spc nodes!
				loads->AddObject(new Pengrid(iomodel->loadcounter+i+1,i,iomodel,DamageEvolutionAnalysisEnum));
			}
		}
	}
	iomodel->DeleteData(1,DamageSpcdamageEnum);

	/*Assign output pointer: */
	*ploads=loads;
	
}
