/*!\file:  adjointstressbalance_core.cpp
 * \brief compute inverse method adjoint state
 */ 

#include "./cores.h"
#include "../toolkits/toolkits.h"
#include "../classes/classes.h"
#include "../shared/shared.h"
#include "../modules/modules.h"
#include "../solutionsequences/solutionsequences.h"

void adjointstressbalance_core(FemModel* femmodel){

	/*parameters: */
	bool isFS;
	bool save_results;
	bool conserve_loads   = true;

	/*retrieve parameters:*/
	femmodel->parameters->FindParam(&isFS,FlowequationIsFSEnum);
	femmodel->parameters->FindParam(&save_results,SaveResultsEnum);

	/*Compute velocities*/
	if(VerboseSolution()) _printf0_("   computing velocities\n");
	femmodel->SetCurrentConfiguration(StressbalanceAnalysisEnum);
	solutionsequence_nonlinear(femmodel,conserve_loads); 

	/*Call SurfaceAreax, because some it might be needed by PVector*/
	SurfaceAreax(NULL,femmodel);

	/*Compute adjoint*/
	if(VerboseSolution()) _printf0_("   computing adjoint\n");
	femmodel->SetCurrentConfiguration(StressbalanceAnalysisEnum,AdjointHorizAnalysisEnum);
	solutionsequence_adjoint_linear(femmodel);

	/*Save results*/
	if(save_results || true){
		if(VerboseSolution()) _printf0_("   saving results\n");
		if (isFS){
			int outputs[4] = {AdjointxEnum,AdjointyEnum,AdjointzEnum,AdjointpEnum};
			femmodel->RequestedOutputsx(&femmodel->results,&outputs[0],4);
		}
		else{
			int outputs[2] = {AdjointxEnum,AdjointyEnum};
			femmodel->RequestedOutputsx(&femmodel->results,&outputs[0],2);
		}
	}
}
