/*\file Misfit.c
 *\brief: compute misfit between modeled velocity and observed velocity
 */

#include "./Misfit.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;

	/*input datasets: */
	DataSet* elements=NULL;
	DataSet* nodes=NULL;
	DataSet* loads=NULL;
	DataSet* materials=NULL;
	ParameterInputs* inputs=NULL;
	int               analysis_type;
	int               sub_analysis_type;

	/* output datasets: */
	double J;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&MisfitUsage);

	/*Input datasets: */
	FetchData((void**)&elements,NULL,NULL,ELEMENTS,"DataSet",NULL);
	FetchData((void**)&nodes,NULL,NULL,NODES,"DataSet",NULL);
	FetchData((void**)&loads,NULL,NULL,LOADS,"DataSet",NULL);
	FetchData((void**)&materials,NULL,NULL,MATERIALS,"DataSet",NULL);
	FetchData((void**)&analysis_type,NULL,NULL,ANALYSIS,"Integer",NULL);
	FetchData((void**)&sub_analysis_type,NULL,NULL,SUBANALYSIS,"Integer",NULL);

	/*Fetch inputs: */
	inputs=new ParameterInputs;
	inputs->Init(INPUTS);

	/*!Call core code: */
	Misfitx(&J, elements,nodes,loads,materials,inputs,analysis_type,sub_analysis_type);

	/*write output : */
	WriteData(MISFIT,&J,0,0,"Scalar",NULL);

	/*Free ressources: */
	delete elements;
	delete nodes;
	delete loads;
	delete materials;
	delete inputs;

	/*end module: */
	MODULEEND();
}

void MisfitUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [J] = %s(elements, nodes,loads, materials, parameters, inputs);\n",__FUNCT__);
	_printf_("\n");
}
