/*!\file: CreateParametersMelting.cpp
 * \brief driver for creating parameters dataset, for diagnostic horiz analysis.
 */ 

#undef __FUNCT__ 
#define __FUNCT__ "CreateParametersMelting"

#include "../../DataSet/DataSet.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../Model.h"

void CreateParametersMelting(DataSet** pparameters,Model* model,ConstDataHandle model_handle){
	
	Param*   param = NULL;
	DataSet* parameters=NULL;
	int      count;
	int i;

	double* melting=NULL;

	/*recover parameters : */
	parameters=*pparameters;

	count=parameters->Size();

	/* get initial melting if transient*/
	if(model->sub_analysis_type==TransientAnalysisEnum()){

		/*Get melting: */
		ModelFetchData((void**)&melting,NULL,NULL,model_handle,"melting","Matrix","Mat");
		if(melting) {
			for(i=0;i<model->numberofnodes;i++)melting[i]=melting[i]/model->yts;   //m/s instead of m/yr
		}
		else{
			for(i=0;i<model->numberofnodes;i++)melting[i]=0;
		}

		count++;
		param= new Param(count,"m_g",DOUBLEVEC);
		if(melting) param->SetDoubleVec(melting,model->numberofnodes);
		else param->SetDoubleVec(melting,0);
		parameters->AddObject(param);

		/*Free melting: */
		xfree((void**)&melting);
	}
	
	/*Assign output pointer: */
	*pparameters=parameters;
}
