/*!\file: CreateParameters.cpp
 * \brief general driver for creating parameters dataset
 */ 

#undef __FUNCT__ 
#define __FUNCT__ "CreateParameters"

#include "../DataSet/DataSet.h"
#include "../toolkits/toolkits.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "../objects/objects.h"
#include "../shared/shared.h"
#include "../MeshPartitionx/MeshPartitionx.h"
#include "./Model.h"

void CreateParameters(DataSet** pparameters,Model* model,ConstDataHandle model_handle){
	
	int i;
	
	DataSet* parameters = NULL;
	Param*   param = NULL;
	int      count=1;
	int      numberofdofspernode;
	int      dim;


	/*Initialize dataset: */
	parameters   = new DataSet(ParametersEnum());
	
	//analysis and subanalysis
	count++;
	param= new Param(count,"analysis_type",INTEGER);
	param->SetInteger(model->analysis_type);
	parameters->AddObject(param);

	count++;
	param= new Param(count,"sub_analysis_type",INTEGER);
	param->SetInteger(model->sub_analysis_type);
	parameters->AddObject(param);

	//dimension 2d or 3d:
	if (strcmp(model->meshtype,"2d")==0)dim=2;
	else dim=3;

	count++;
	param= new Param(count,"dim",INTEGER);
	param->SetInteger(dim);
	parameters->AddObject(param);

	//elements types
	count++;
	param= new Param(count,"ishutter",INTEGER);
	param->SetInteger(model->ishutter);
	parameters->AddObject(param);

	count++;
	param= new Param(count,"ismacayealpattyn",INTEGER);
	param->SetInteger(model->ismacayealpattyn);
	parameters->AddObject(param);


	count++;
	param= new Param(count,"isstokes",INTEGER);
	param->SetInteger(model->isstokes);
	parameters->AddObject(param);

	/*debug: */
	param= new Param(count,"debug",INTEGER);
	param->SetInteger(model->debug);
	parameters->AddObject(param);

	/*eps_rel: */
	count++;
	param= new Param(count,"eps_rel",DOUBLE);
	param->SetDouble(model->eps_rel);
	parameters->AddObject(param);

	/*eps_abs: */
	count++;
	param= new Param(count,"eps_abs",DOUBLE);
	param->SetDouble(model->eps_abs);
	parameters->AddObject(param);

	/*yts: */
	count++;
	param= new Param(count,"yts",DOUBLE);
	param->SetDouble(model->yts);
	parameters->AddObject(param);

	/*dt: */
	count++;
	param= new Param(count,"dt",DOUBLE);
	param->SetDouble(model->dt);
	parameters->AddObject(param);

	/*ndt: */
	count++;
	param= new Param(count,"ndt",DOUBLE);
	param->SetDouble(model->ndt);
	parameters->AddObject(param);

	/*penalty_offset: */
	count++;
	param= new Param(count,"penalty_offset",DOUBLE);
	param->SetDouble(model->penalty_offset);
	parameters->AddObject(param);

	/*sparsity: */
	count++;
	param= new Param(count,"sparsity",DOUBLE);
	param->SetDouble(model->sparsity);
	parameters->AddObject(param);

	/*lowmem: */
	count++;
	param= new Param(count,"lowmem",INTEGER);
	param->SetInteger(model->lowmem);
	parameters->AddObject(param);

	/*connectivity: */
	count++;
	param= new Param(count,"connectivity",INTEGER);
	param->SetInteger(model->connectivity);
	parameters->AddObject(param);

	/*beta: */
	count++;
	param= new Param(count,"beta",DOUBLE);
	param->SetDouble(model->beta);
	parameters->AddObject(param);

	/*meltingpoint: */
	count++;
	param= new Param(count,"meltingpoint",DOUBLE);
	param->SetDouble(model->meltingpoint);
	parameters->AddObject(param);

	/*latentheat: */
	count++;
	param= new Param(count,"latentheat",DOUBLE);
	param->SetDouble(model->latentheat);
	parameters->AddObject(param);

	/*heatcapacity: */
	count++;
	param= new Param(count,"heatcapacity",DOUBLE);
	param->SetDouble(model->heatcapacity);
	parameters->AddObject(param);

	/*penalty_melting: */
	count++;
	param= new Param(count,"penalty_melting",DOUBLE);
	param->SetDouble(model->penalty_melting);
	parameters->AddObject(param);

	/*min_thermal_constraints: */
	count++;
	param= new Param(count,"min_thermal_constraints",INTEGER);
	param->SetInteger(model->min_thermal_constraints);
	parameters->AddObject(param);

	/*stokesreconditioning: */
	count++;
	param= new Param(count,"stokesreconditioning",DOUBLE);
	param->SetDouble(model->stokesreconditioning);
	parameters->AddObject(param);

	/*waitonlock: */
	count++;
	param= new Param(count,"waitonlock",INTEGER);
	param->SetInteger(model->waitonlock);
	parameters->AddObject(param);

	/*solverstring: */
	count++;
	param= new Param(count,"solverstring",STRING);
	param->SetString(model->solverstring);
	parameters->AddObject(param);

	/*plot: */
	count++;
	param= new Param(count,"plot",INTEGER);
	param->SetInteger(model->plot);
	parameters->AddObject(param);

	/*numberofgrids: */
	count++;
	param= new Param(count,"numberofnodes",INTEGER);
	param->SetInteger(model->numberofnodes);
	parameters->AddObject(param);

	/*Deal with numberofdofspernode: */
	DistributeNumDofs(&numberofdofspernode,model->analysis_type,model->sub_analysis_type);

	count++;
	param= new Param(count,"numberofdofspernode",INTEGER);
	param->SetInteger(numberofdofspernode);
	parameters->AddObject(param);
	
	/*All our datasets are already ordered by ids. Set presort flag so that later on, when sorting is requested on these 
	 * datasets, it will not be redone: */
	parameters->Presort();

	/*Assign output pointer: */
	*pparameters=parameters;
}
