/* 
 * \brief: damgage_core.cpp: core for the damage solution
 */ 

#include "./analyses.h"
#include "../toolkits/toolkits.h"
#include "../classes/classes.h"
#include "../shared/shared.h"
#include "../modules/modules.h"
#include "../solutionsequences/solutionsequences.h"

void damage_core(FemModel* femmodel){

	/*intermediary*/
	bool   save_results;
	bool   dakota_analysis  = false;
	int    solution_type;

	if(VerboseSolution()) _printf0_("   computing damage\n");
	
	//first recover parameters common to all solutions
	femmodel->parameters->FindParam(&save_results,SaveResultsEnum);
	femmodel->parameters->FindParam(&dakota_analysis,QmuIsdakotaEnum);
	femmodel->parameters->FindParam(&solution_type,SolutionTypeEnum);

	if(dakota_analysis && solution_type!=TransientSolutionEnum){
		femmodel->SetCurrentConfiguration(DamageEvolutionAnalysisEnum);
		ResetConstraintsx(femmodel);
	}

	femmodel->SetCurrentConfiguration(DamageEvolutionAnalysisEnum);
	solutionsequence_linear(femmodel);

	if(save_results){
		if(VerboseSolution()) _printf0_("   saving results\n");
		const char* outputs [] = {"DamageD"};
		femmodel->RequestedOutputsx(&femmodel->results,(char**)&outputs[0],1);
	}
}
