/*! \file TriaP1ElementResult.h 
 *  \brief: header file for TriaP1ElementResult object
 */

#ifndef _TRIAP1ELEMENTRESULT_H_
#define _TRIAP1ELEMENTRESULT_H_

/*Headers:*/
#include "../Inputs/Input.h"

class TriaP1ElementResult: public ElementResult{

	private: 
		int    enum_type;
		IssmDouble values[3];
		int    step;
		IssmDouble time;

	public:

		/*TriaP1ElementResult constructors, destructors: {{{*/
		TriaP1ElementResult();
		TriaP1ElementResult(int enum_type,IssmDouble* values,int step,IssmDouble time);
		~TriaP1ElementResult();
		/*}}}*/
		/*Object virtual functions definitions:{{{ */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   ObjectEnum();
		Object* copy();
		/*}}}*/
		/*ElementResult virtual functions definitions: {{{*/
		IssmDouble  GetTime(void){return time;};
		int     GetStep(void){return step;};
		int     NumberOfNodalValues(void);
		/*}}}*/
		/*TriaP1ElementResult management: {{{*/
		char* GetResultName();
		void GetVectorFromResults(Vector<IssmDouble>* vector,int* doflist,int* connectivitylist,int numdofs);
		void GetElementVectorFromResults(Vector<IssmDouble>* vector,int dof);
		/*}}}*/

};
#endif  /* _TRIAP1ELEMENTRESULT_H */
