/*! \file PentaP1ElementResult.h 
 *  \brief: header file for PentaP1ElementResult object
 *  this object is just a PentaP1Input with additional time and step info.
 */

#ifndef _PENTAP1ELEMENTRESULT_H_
#define _PENTAP1ELEMENTRESULT_H_

/*Headers:*/
#include "../Inputs/Input.h"

class PentaP1ElementResult: public ElementResult{

	private: 
		int    enum_type;
		IssmDouble values[6];
		int    step;
		IssmDouble time;

	public:

		/*PentaP1ElementResult constructors, destructors: {{{*/
		PentaP1ElementResult();
		PentaP1ElementResult(int enum_type,IssmDouble* values,int step, IssmDouble time);
		~PentaP1ElementResult();
		/*}}}*/
		/*Object virtual functions definitions:{{{ */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   ObjectEnum();
		Object* copy();
		/*}}}*/
		/*ElementResult virtual functions definitions: {{{*/
		IssmDouble  GetTime(void){return time;};
		int     GetStep(void){return step;};
		int     NumberOfNodalValues(void);
		/*}}}*/
		/*PentaP1ElementResult management: {{{*/
		char* GetResultName();
		void GetVectorFromResults(Vector<IssmDouble>* vector,int* doflist,int* connectivitylist,int numdofs);
		void GetElementVectorFromResults(Vector<IssmDouble>* vector,int dof);
		/*}}}*/

};
#endif  /* _PENTAP1ELEMENTRESULT_H */
