%STEADYSTATE class definition
%
%   Usage:
%      steadystate=steadystate();

classdef steadystate
	properties (SetAccess=public) 
		reltol            = 0;
		maxiter           = 0;
		requested_outputs = {};
	end
	methods
		function obj = steadystate(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{
			%maximum of steady state iterations
			obj.maxiter=100;

			%Relative tolerance for the steadystate convertgence
			obj.reltol=0.01;

			%default output
			obj.requested_outputs={'default'};
		end % }}}
		function list=defaultoutputs(self,md) % {{{

			list =  [md.stressbalance.defaultoutputs(md) md.thermal.defaultoutputs(md)];

		end % }}}
		function md = checkconsistency(obj,md,solution,analyses) % {{{

			%Early return
			if solution~=SteadystateSolutionEnum(), return; end;

			if md.timestepping.time_step~=0,
				md = checkmessage(md,['for a steadystate computation, timestepping.time_step must be zero.']);
			end
			md = checkfield(md,'steadystate.requested_outputs','stringrow',1);

			if isnan(md.stressbalance.reltol),
				md = checkmessage(md,['for a steadystate computation, stressbalance.reltol (relative convergence criterion) must be defined!']);
			end
		end % }}}
		function disp(obj) % {{{
			disp(sprintf('   steadystate solution parameters:'));

			fielddisplay(obj,'reltol','relative tolerance criterion');
			fielddisplay(obj,'maxiter','maximum number of iterations');
			fielddisplay(obj,'requested_outputs','additional requested outputs');

		end % }}}
		function marshall(obj,md,fid) % {{{
			WriteData(fid,'object',obj,'fieldname','reltol','format','Double');
			WriteData(fid,'object',obj,'fieldname','maxiter','format','Integer');

			%process requested outputs
			outputs = obj.requested_outputs;
			pos  = find(ismember(outputs,'default'));
			if ~isempty(pos),
				outputs(pos) = [];                         %remove 'default' from outputs
				outputs      = [outputs defaultoutputs(obj,md)]; %add defaults
			end
			WriteData(fid,'data',outputs,'enum',SteadystateRequestedOutputsEnum,'format','StringArray');
		end % }}}
	end
end
