/*!\file: bedslope_core.cpp
 * \brief: core of the slope solution 
 */ 

#include "./analyses.h"
#include "../toolkits/toolkits.h"
#include "../classes/classes.h"
#include "../shared/shared.h"
#include "../modules/modules.h"
#include "../solutionsequences/solutionsequences.h"

void bedslope_core(FemModel* femmodel){

	/*parameters: */
	bool save_results;
	int  meshtype;

	/*Recover some parameters: */
	femmodel->parameters->FindParam(&save_results,SaveResultsEnum);
	femmodel->parameters->FindParam(&meshtype,MeshTypeEnum);

	if(VerboseSolution()) _printf0_("   computing slope\n");

	/*Call on core computations: */
	femmodel->SetCurrentConfiguration(BedSlopeAnalysisEnum,BedSlopeXAnalysisEnum);
	solutionsequence_linear(femmodel);
	if(meshtype!=Mesh2DverticalEnum){
		femmodel->SetCurrentConfiguration(BedSlopeAnalysisEnum,BedSlopeYAnalysisEnum);
		solutionsequence_linear(femmodel);
	}

	if(save_results){
		if(VerboseSolution()) _printf0_("   saving results\n");
		if(meshtype!=Mesh2DverticalEnum){
			const char* outputs [] = {"BedSlopeX"};
			femmodel->RequestedOutputsx(&femmodel->results,(char**)&outputs[0],1);
		}
		else{
			const char* outputs [] = {"BedSlopeX","BedSlopeY"};
			femmodel->RequestedOutputsx(&femmodel->results,(char**)&outputs[0],2);
		}
	}

}
