/*
 * \file Results.cpp
 * \brief: Implementation of the Results class, derived from DataSet class.
 */

/*Headers: {{{*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "./Results.h"
#include "./ExternalResult.h"
#include "../../shared/shared.h"
#include "../Params/Parameters.h"
#include "../ElementResults/ElementResult.h"

using namespace std;
/*}}}*/

/*Object constructors and destructor*/
/*FUNCTION Results::Results(){{{*/
Results::Results(){
	enum_type=ResultsEnum;
	return;
}
/*}}}*/
/*FUNCTION Results::~Results(){{{*/
Results::~Results(){
	return;
}
/*}}}*/

/*Object management*/
/*FUNCTION Results::Write{{{*/
void Results::Write(Parameters* parameters){

	FILE       *fid  = NULL;
	bool        io_gather;

	/*Recover file descriptor: */
	parameters->FindParam(&fid,OutputFilePointerEnum);
	parameters->FindParam(&io_gather,SettingsIoGatherEnum);

	for(int i=0;i<this->Size();i++){
		ExternalResult* result=dynamic_cast<ExternalResult*>(this->GetObjectByOffset(i));
		result->WriteData(fid,io_gather);
	}

}
/*}}}*/
/*FUNCTION Results::AddResult(ElementResult* in_result){{{*/
int Results::AddResult(ElementResult* in_result){

	/*First, go through dataset of inputs and check whether any input 
	 * with the same name is already in. If so, erase the corresponding 
	 * object before adding this new one: */
	vector<Object*>::iterator object;
	ElementResult* result=NULL;

	/*In debugging mode, check that the input is not a NULL pointer*/
	_assert_(in_result);

	for(object=objects.begin() ; object<objects.end(); object++){

		result=dynamic_cast<ElementResult*>(*object);

		if(result->InstanceEnum()==in_result->InstanceEnum()){
			if(result->GetStep()==in_result->GetStep()){
				this->DeleteObject(result);
				break;
			}
		}
	}
	this->AddObject(in_result);

	return 1;
}
/*}}}*/
