/*!\file:  Element.h
 * \brief abstract class for Element object
 * This class is a place holder for the Tria and the Penta elements. 
 * It is derived from Element, so DataSets can contain them.
 */ 

#ifndef _ELEMENT_H_
#define _ELEMENT_H_

/*Headers:*/
/*{{{*/
#include "../../datastructures/datastructures.h"
#include "../Update.h"

class DataSet;
class Parameters;
class Patch;
class Elements;
class Loads;
class Node;
class Nodes;
class Vertices;
class Materials;
template <class doublematrix> class Matrix;
template <class doubletype> class Vector;

#include "../../toolkits/toolkits.h"
/*}}}*/

class Element: public Object,public Update{

	public: 

		virtual        ~Element(){};

		virtual void   Configure(Elements* elements,Loads* loads,Nodes* nodes,Vertices* vertices,Materials* materials,Parameters* parameters)=0;
		virtual void   SetCurrentConfiguration(Elements* elements,Loads* loads,Nodes* nodes,Materials* materials,Parameters* parameters)=0;
		virtual void   SetwiseNodeConnectivity(int* d_nz,int* o_nz,Node* node,bool* flags,int* flagsindices,int set1_enum,int set2_enum)=0;
		virtual void   CreateKMatrix(Matrix<IssmDouble>* Kff, Matrix<IssmDouble>*  Kfs)=0;
		virtual void   CreateDVector(Vector<IssmDouble>* df)=0;
		virtual void   CreatePVector(Vector<IssmDouble>* pf)=0;
		virtual void   CreateJacobianMatrix(Matrix<IssmDouble>* Jff)=0;
		virtual void   GetSolutionFromInputs(Vector<IssmDouble>* solution)=0;
		virtual int    GetNodeIndex(Node* node)=0;
		virtual int    GetNumberOfNodes(void)=0;
		virtual void   GetNodesSidList(int* sidlist)=0;
		virtual void   GetNodesLidList(int* sidlist)=0;

		virtual int    Sid()=0;
		virtual bool   IsFloating()=0; 
		virtual bool   IsNodeOnShelfFromFlags(IssmDouble* flags)=0; 
		virtual bool   IsOnBed()=0;
		virtual void   GetInputListOnVertices(IssmDouble* pvalue,int enumtype)=0;
		virtual void   GetInputListOnVertices(IssmDouble* pvalue,int enumtype,IssmDouble defaultvalue)=0;
		virtual void   GetInputValue(IssmDouble* pvalue,Node* node,int enumtype)=0;
		virtual void   GetMaterialInputValue(IssmDouble* pvalue,Node* node,int enumtype)=0;

		virtual IssmDouble SurfaceArea(void)=0;
		virtual void   InputDepthAverageAtBase(int enum_type,int average_enum_type,int object_enum)=0;
		virtual void   ComputeBasalStress(Vector<IssmDouble>* sigma_b)=0;
		virtual void   ComputeStrainRate(Vector<IssmDouble>* eps)=0;
		virtual void   PatchSize(int* pnumrows, int* pnumvertices,int* pnumnodes)=0;
		virtual void   PatchFill(int* pcount, Patch* patch)=0;
		virtual void   ListResultsInfo(int** results_enums,int** results_size,IssmDouble** results_times,int** results_steps,int* num_results)=0;
		virtual void   ResultInterpolation(int* pinterpolation,int output_enum)=0;
		virtual void   ResultToVector(Vector<IssmPDouble>* vector,int output_enum)=0;
		virtual void   DeleteResults(void)=0;
		virtual void   Update(int index, IoModel* iomodel,int analysis_counter,int analysis_type,int finite_element)=0;
		virtual void   InputToResult(int enum_type,int step,IssmDouble time)=0;
		virtual void   InputDuplicate(int original_enum,int new_enum)=0;
		virtual void   InputCreate(IssmDouble* vector,IoModel* iomodel,int M,int N,int vector_type,int vector_enum,int code)=0;
		virtual void   RequestedOutput(int output_enum,int step,IssmDouble time)=0;

		virtual int    NodalValue(IssmDouble* pvalue, int index, int natureofdataenum)=0;
		virtual void   InputScale(int enum_type,IssmDouble scale_factor)=0;
		virtual void   GetVectorFromInputs(Vector<IssmDouble>* vector, int name_enum)=0;
		virtual void   GetVectorFromResults(Vector<IssmDouble>* vector,int id,int enum_in,int interp)=0;
		virtual IssmDouble TimeAdapt()=0;
		virtual void   PositiveDegreeDay(IssmDouble* pdds,IssmDouble* pds,IssmDouble signorm)=0;
		virtual void   Delta18oParameterization(void)=0;
		virtual void   SmbGradients()=0;
		virtual void   ResetCoordinateSystem()=0;

		#ifdef _HAVE_RESPONSES_
		virtual void   AverageOntoPartition(Vector<IssmDouble>* partition_contributions,Vector<IssmDouble>* partition_areas,IssmDouble* vertex_response,IssmDouble* qmu_part)=0;
		virtual void   MinVel(IssmDouble* pminvel)=0;
		virtual void   MaxVel(IssmDouble* pmaxvel)=0;
		virtual void   MinVx(IssmDouble* pminvx)=0;
		virtual void   MaxVx(IssmDouble* pmaxvx)=0;
		virtual void   MaxAbsVx(IssmDouble* pmaxabsvx)=0;
		virtual void   MinVy(IssmDouble* pminvy)=0;
		virtual void   MaxVy(IssmDouble* pmaxvy)=0;
		virtual void   MaxAbsVy(IssmDouble* pmaxabsvy)=0;
		virtual void   MinVz(IssmDouble* pminvz)=0;
		virtual void   MaxVz(IssmDouble* pmaxvz)=0;
		virtual void   MaxAbsVz(IssmDouble* pmaxabsvz)=0;
		virtual IssmDouble MassFlux(IssmDouble* segment)=0;
		virtual IssmDouble MassFlux(IssmDouble x1,IssmDouble y1, IssmDouble x2, IssmDouble y2,int segment_id)=0;
		virtual void   ElementResponse(IssmDouble* presponse,int response_enum)=0;
		virtual IssmDouble IceVolume(void)=0;
		virtual IssmDouble IceVolumeAboveFloatation(void)=0;
		virtual IssmDouble TotalSmb(void)=0;
		#endif

		#ifdef _HAVE_GIA_
		virtual void   GiaDeflection(Vector<IssmDouble>* wg,Vector<IssmDouble>* dwgdt,IssmDouble* x,IssmDouble* y)=0;
		#endif

		#ifdef _HAVE_CONTROL_
		virtual void   Gradj(Vector<IssmDouble>* gradient,int control_type,int control_index)=0;
		virtual IssmDouble ThicknessAbsMisfit(void)=0;
		virtual IssmDouble SurfaceAbsVelMisfit(void)=0;
		virtual IssmDouble SurfaceRelVelMisfit(void)=0;
		virtual IssmDouble SurfaceLogVelMisfit(void)=0;
		virtual IssmDouble SurfaceLogVxVyMisfit(void)=0;
		virtual IssmDouble SurfaceAverageVelMisfit(void)=0;
		virtual IssmDouble ThicknessAbsGradient(void)=0;
		virtual IssmDouble ThicknessAlongGradient(void)=0;
		virtual IssmDouble ThicknessAcrossGradient(void)=0;
		virtual IssmDouble BalancethicknessMisfit(void)=0;
		virtual IssmDouble RheologyBbarAbsGradient(void)=0;
		virtual IssmDouble DragCoefficientAbsGradient(void)=0;
		virtual void   ControlInputGetGradient(Vector<IssmDouble>* gradient,int enum_type,int control_index)=0;
		virtual void   ControlInputSetGradient(IssmDouble* gradient,int enum_type,int control_index)=0;
		virtual void   ControlInputScaleGradient(int enum_type, IssmDouble scale)=0;
		virtual void   GetVectorFromControlInputs(Vector<IssmDouble>* gradient,int control_enum,int control_index,const char* data)=0;
		virtual void   SetControlInputsFromVector(IssmDouble* vector,int control_enum,int control_index)=0;
		virtual void   InputControlUpdate(IssmDouble scalar,bool save_parameter)=0;
		#endif

		virtual void UpdateConstraintsExtrudeFromBase(void)=0;
		virtual void UpdateConstraintsExtrudeFromTop(void)=0;

		#ifdef _HAVE_THERMAL_
		virtual void UpdateBasalConstraintsEnthalpy(void)=0;
		virtual void ComputeBasalMeltingrate(void)=0;
		virtual void DrainWaterfraction(void)=0;
		#endif

		#ifdef _HAVE_HYDROLOGY_
		virtual void GetHydrologyDCInefficientHmax(IssmDouble* ph_max, Node* innode)=0;
		virtual void GetHydrologyTransfer(Vector<IssmDouble>* transfer)=0; 
		virtual void HydrologyEPLGetMask(Vector<IssmDouble>* mask)=0;
		virtual void HydrologyEPLGetActive(Vector<IssmDouble>* active)=0;
		#endif

		#ifdef _HAVE_GROUNDINGLINE_
		virtual void   MigrateGroundingLine(IssmDouble* sheet_ungrounding)=0;
		virtual void   PotentialUngrounding(Vector<IssmDouble>* potential_sheet_ungrounding)=0;
		virtual int    UpdatePotentialUngrounding(IssmDouble* potential_sheet_ungrounding,Vector<IssmDouble>* vec_nodes_on_iceshelf,IssmDouble* nodes_on_iceshelf)=0;
		#endif

};
#endif
