/*! \file TransientInput.h 
 *  \brief: header file for transientinput object
 */

#ifndef _TRANSIENTINPUT_H_
#define _TRANSIENTINPUT_H_

/*Headers:*/
/*{{{*/
#include "./Input.h"
class GaussTria;
class Parameters;
class GaussPenta;
/*}}}*/

class TransientInput: public Input{

	public:
		int         enum_type;
		int         numtimesteps;
		Inputs     *inputs;
		IssmDouble *timesteps;
		Parameters *parameters;     //to find current time.

		/*TransientInput constructors, destructors: {{{*/
		TransientInput();
		TransientInput(int enum_type);
		~TransientInput();
		void AddTimeInput(Input* input,IssmDouble time);
		/*}}}*/
		/*Object virtual functions definitions:{{{*/
		void  Echo();
		void  DeepEcho();
		int   Id();
		int   ObjectEnum();
		Object* copy();
		/*}}}*/
		/*TransientInput management: {{{*/
		int    InstanceEnum();
		Input* SpawnTriaInput(int location);
		Input* SpawnSegInput(int index1,int index2);
		Input* PointwiseDivide(Input* forcingB){_error_("not implemented yet");};
		Input* PointwiseMin(Input* forcingB){_error_("not implemented yet");};
		Input* PointwiseMax(Input* forcingB){_error_("not implemented yet");};
		ElementResult* SpawnResult(int step, IssmDouble time);
		int  GetResultInterpolation(void){_error_("not implemented");};
		void Configure(Parameters* parameters);
		/*}}}*/
		/*numerics: {{{*/
		void GetInputValue(bool* pvalue){_error_("not implemented yet");};
		void GetInputValue(int* pvalue){_error_("not implemented yet");};
		void GetInputValue(IssmDouble* pvalue){_error_("not implemented yet");};
		void GetInputValue(IssmDouble* pvalue,GaussSeg* gauss){_error_("not implemented yet");};
		void GetInputValue(IssmDouble* pvalue,GaussTria* gauss);
		void GetInputValue(IssmDouble* pvalue,GaussPenta* gauss);
		void GetInputValue(IssmDouble* pvalue,GaussTria* gauss,IssmDouble time);
		void GetInputValue(IssmDouble* pvalue,GaussPenta* gauss,IssmDouble time);
		void GetInputValue(IssmDouble* pvalue,GaussTria* gauss ,int index){_error_("not implemented yet");};
		void GetInputValue(IssmDouble* pvalue,GaussPenta* gauss ,int index){_error_("not implemented yet");};
		void GetInputDerivativeValue(IssmDouble* derivativevalues, IssmDouble* xyz_list, GaussSeg* gauss){_error_("not implemented yet");};
		void GetInputDerivativeValue(IssmDouble* derivativevalues, IssmDouble* xyz_list, GaussTria* gauss);
		void GetInputDerivativeValue(IssmDouble* derivativevalues, IssmDouble* xyz_list, GaussPenta* gauss){_error_("not implemented yet");};
		void GetInputAverage(IssmDouble* pvalue);
		void GetInputAllTimeAverages(IssmDouble** pvalues,IssmDouble** ptimes, int* pnumtimes);
		void GetInputUpToCurrentTimeAverages(IssmDouble** pvalues, IssmDouble** ptimes, int* pnumtimes, IssmDouble currenttime);
		void GetVxStrainRate2d(IssmDouble* epsilonvx,IssmDouble* xyz_list, GaussTria* gauss){_error_("not implemented yet");};
		void GetVyStrainRate2d(IssmDouble* epsilonvy,IssmDouble* xyz_list, GaussTria* gauss){_error_("not implemented yet");};
		void GetVxStrainRate3d(IssmDouble* epsilonvx,IssmDouble* xyz_list, GaussPenta* gauss){_error_("not implemented yet");};
		void GetVyStrainRate3d(IssmDouble* epsilonvy,IssmDouble* xyz_list, GaussPenta* gauss){_error_("not implemented yet");};
		void GetVzStrainRate3d(IssmDouble* epsilonvz,IssmDouble* xyz_list, GaussPenta* gauss){_error_("not implemented yet");};
		void GetVxStrainRate3dHO(IssmDouble* epsilonvx,IssmDouble* xyz_list, GaussPenta* gauss){_error_("not implemented yet");};
		void GetVyStrainRate3dHO(IssmDouble* epsilonvy,IssmDouble* xyz_list, GaussPenta* gauss){_error_("not implemented yet");};
		void ChangeEnum(int newenumtype);

		void SquareMin(IssmDouble* psquaremin,Parameters* parameters);
		void ConstrainMin(IssmDouble minimum){_error_("not implemented yet");};
		void Set(IssmDouble setvalue){_error_("Set not implemented yet");};
		void Scale(IssmDouble scale_factor){_error_("not implemented yet");};
		void AXPY(Input* xforcing,IssmDouble scalar){_error_("not implemented yet");};
		void Constrain(IssmDouble cm_min, IssmDouble cm_max){_error_("not implemented yet");};
		IssmDouble InfinityNorm(void);
		IssmDouble Max(void);
		IssmDouble MaxAbs(void);
		IssmDouble Min(void);
		IssmDouble MinAbs(void);
		void Extrude(void);
		void VerticallyIntegrate(Input* thickness_forcing){_error_("not supported yet");};
		void GetVectorFromInputs(Vector<IssmDouble>* vector,int* doflist);
		void GetTimeValues(IssmDouble* values,IssmDouble time){_error_("not implemented yet");};
		Input* GetTimeInput(IssmDouble time);
		/*}}}*/

};
#endif  /* _TRANSIENTINPUT_H */
