/*!\file: extrudefromtop_core.cpp
 * \brief: core of the extrusion solution
 */ 

#include "./analyses.h"
#include "../toolkits/toolkits.h"
#include "../classes/classes.h"
#include "../shared/shared.h"
#include "../solutionsequences/solutionsequences.h"
#include "../modules/modules.h"

void extrudefromtop_core(FemModel* femmodel){

	if(VerboseSolution()) _printf0_("extruding solution from top...\n");

	/*Call on core computations: */
	femmodel->SetCurrentConfiguration(ExtrudeFromTopAnalysisEnum);
	femmodel->UpdateConstraintsExtrudeFromTopx();
	solutionsequence_linear(femmodel);

}
