#!/bin/bash
#generate html report from nightly.log output file

#Process log
cat nightly.log | grep 'package: macayeal'      | grep -v "not supported yet" > macayeal.log
cat nightly.log | grep 'package: ice'           | grep -v "not supported yet" > ice.log
cat nightly.log | grep 'package: cielo_serial'  | grep -v "not supported yet" > cielo_serial.log
cat nightly.log | grep 'package: cielo_parallel'| grep -v "not supported yet" > cielo_parallel.log
cat nightly.log | grep 'NIGHTLYRUNTERMINATEDCORRECTLY'                        > check.log
cat nightly.log | grep 'ERROR'                  | grep -v "PETSC ERROR"       > errors.log
cat nightly.log | grep 'SUCCESS'                                              > success.log
cat errors.log success.log                                                    > tests.log

#create some variables
if [ $(ls -1 $ISSM_DIR/bin | wc -l) -le 20 ];
then
	IS_INSTALL=0
else
	IS_INSTALL=1
fi
if [ $(wc -l nightly.log | awk '{printf("%s",$1);}')  -eq 0 ] 
then
	IS_RUN=0
else
	IS_RUN=1
fi
if [ $(wc -l check.log | awk '{printf("%s",$1);}')  -eq 0 ] 
then
	IS_END=0
else
	IS_END=1
fi

#style
H1_STYLE='width="800px" cellpadding="20"'
H1_FONT='style="color:#6495ed; font-family:Arial, Verdana, Tahoma; font-weight: bold; font-size:35px;" align="center"'

H2_STYLE='width="840px" cellpadding="20"'
H2_FONT='style="color:#6495ed; font-family:Arial, Verdana, Tahoma; font-size:28px; font-weight: bold;" align="left"'

TABLE_STYLE='width="820px" rules=none bgcolor="#ffffdd" border=1 bordercolor="#000000" cellpadding="3"'
TABLE_FONT='style="color:#404040; font-family:Arial, Verdana, Tahoma; font-size:14; font-weight: normal;" align="left"'

BODY_STYLE='width="820px"'
BODY_FONT="style=\"color:#404040; font-family:Arial, Verdana, Tahoma; font-size:14px;\""

NOTEST_STYLE='width="650px"'
NOTEST_FONT='style="color:#FF0000; font-family:Arial, Verdana, Tahoma; font-size:14px;" align="left"'

FOOTER_STYLE='width="800px"  cellpadding="10"'
FOOTER_FONT='style="color:#404040; font-family:Arial, Verdana, Tahoma; font-size:12px; font-weight: normal;" align="center"'

#build report.html

#first: summary
cat << END > summary.html
<div align="center">
<table $H1_STYLE><tr><td $H1_FONT>ISSM Nightly run report</td></tr></table>

<table $TABLE_STYLE>
<tr> 
<td $TABLE_FONT>host: $HOST_NAME</td>
<td $TABLE_FONT>date: $TODAY</td>
</tr>
<tr>
<td $TABLE_FONT>OS: $OS</td>
<td $TABLE_FONT>total elapsed time: $ELAPSED_TOTAL</td>
</tr>
<tr>
<td $TABLE_FONT>release: $ISSM_RELEASE</td>
<td $TABLE_FONT>installation elapsed time: $ELAPSED_INSTAL</td>
</tr>
<tr>
$(#print status
if [ $(echo $IS_INSTALL) = 0 ];
then
	#installation failed, end of report
	echo "<td $TABLE_FONT>status: <span style=\"color:#FF0000\">installation failed</span></td>"
	echo "<td $TABLE_FONT>execution elapsed time: $ELAPSED_RUN</td>"
	echo "</tr>"
	echo "</table>"
	rm check.log errors.log success.log tests.log
else
	#installation successful. Did we go to the end?

	if [ $(echo $IS_RUN) -eq 0 ];
	then
		#run failed, end of report
		echo "<td $TABLE_FONT>status: <span style=\"color:#FF0000\">installation successful but tests runs failed</span></td>"
		echo "<td $TABLE_FONT>execution elapsed time: $ELAPSED_RUN</td>"
		echo "</tr>"
		echo "</table>"
		rm check.log errors.log success.log tests.log

	else

		if [ $(echo $IS_END) -eq 0 ];
		then
			echo "<td $TABLE_FONT>status: <span style=\"color:#FFA500\">stopped before the end</span></td>"
		else
			echo "<td $TABLE_FONT>status: <span style=\"color:#008000\">all test desks have been run</span></td>"
		fi
		echo "<td $TABLE_FONT>execution elapsed time: $ELAPSED_RUN</td>"
		echo "</tr>"
		echo "<tr>"
		echo "<td $TABLE_FONT>number of errors: $(wc -l errors.log | awk '{printf("%s",$1);}')/$(wc -l tests.log | awk '{printf("%s",$1);}';  rm errors.log)</td>"
		echo "<td $TABLE_FONT>  </td>"
		echo "</tr>"
		echo "<tr>"
		echo "<td $TABLE_FONT>number of success: $(wc -l success.log | awk '{printf("%s",$1);}')/$(wc -l tests.log | awk '{printf("%s",$1);}';  rm success.log tests.log)</td>"
		echo "<td $TABLE_FONT>  </td>"
		echo "</tr>"
		echo "</table>"

		#draw a line and clean up
		echo "<br><hr width=\"900px\">"
		rm check.log
	fi
fi) 
END


#report content
if [ $(echo $IS_INSTALL) = 1 ];
then
	cat << END > content.html
$(for  package in "macayeal" "ice" "cielo_serial" "cielo_parallel"; do

	#enter title
	if [ $package == "macayeal" ];
	then
		echo "<table $H2_STYLE><tr><td $H2_FONT>Macayeal package</td></tr></table>"
	fi
	if [ $package == "ice" ];
	then
		echo "<table $H2_STYLE><tr><td $H2_FONT>Ice package</td></tr></table>"
	fi
	if [ $package == "cielo_serial" ];
	then
		echo "<table $H2_STYLE><tr><td $H2_FONT>Cielo serial package</td></tr></table>"
	fi
	if [ $package == "cielo_parallel" ];
	then
		echo "<table $H2_STYLE><tr><td $H2_FONT>Cielo parallel package</td></tr></table>"
	fi

	#check that at least one Test exists
	if [ `wc -l $package.log | awk '{printf("%s",$1);}'`  = "0" ]; then

		#No Test: use a table to fix entourage bug.
		echo "<table $NOTEST_STYLE><tr><td $NOTEST_FONT>No test found.</td></tr></table>"

	else

		echo "<table $BODY_STYLE cellspacing=\"-1\">"
		echo "<tr> <th $BODY_FONT>Result</th> <th $BODY_FONT>Tolerance</th> <th $BODY_FONT>Test</th>  <th $BODY_FONT>Solution</th> <th $BODY_FONT>Field</th> </tr>"

		# go through the lines of $package.log
		COUNTER=0
		MAX=`wc -l $package.log | awk '{printf("%s",$1);}'`
		while [  $COUNTER -lt $MAX ]; do
			let COUNTER=COUNTER+1 

			echo "<tr>"

			#see wether it is success or error (get color: red or green)
			if [ "`cat $package.log | awk '{ printf "line%so %s\n", NR, $0 }' | awk '/line'$COUNTER'o/ {printf("%s\n",$2);}';`" == "SUCCESS" ];  
			then 
				color="bgcolor=#ddffdd";
			else
				color="bgcolor=#ffdddd";
			fi
			FONT=$(echo "$BODY_FONT $color")

			#build html corresponding line
			cat $package.log | awk '{ printf "line%so %s\n", NR, $0 }' | awk -v FONT="$FONT" '
			/line'$COUNTER'o/ { printf("<td %s>%s</td><td %s> %s%s%s</td><td %s> %s</td><td %s> %s</td><td %s> %s</td>",FONT,$2,FONT,$4,$5,$6,FONT,$8,FONT,$10,FONT,$14);}
			';
			echo "</tr>"
		done

		echo "</table>"
	fi

	#remove log file
	rm $package.log

done)
<br>
END
else
	for  package in "macayeal" "ice" "cielo_serial" "cielo_parallel"; do
		rm $package.log
	done
fi

#last footer
cat << END > footer.html
<br>
<table $FOOTER_STYLE><tr><td $FOOTER_FONT><a href="http://issm.jpl.nasa.gov" title="ISSM website" target="_blank">ISSM</a> nightly run report</td></tr></table>
</div>
END

#concatenate files
if [ $IS_INSTALL -eq 1 ];
then
	if [ $IS_RUN -eq 1 ];
	then
		cat summary.html content.html footer.html > report.html
		rm  summary.html content.html footer.html
	else
		cat summary.html footer.html > report.html
		rm  summary.html footer.html
	fi
else
	cat summary.html footer.html > report.html
	rm  summary.html footer.html
fi
