%CONSTANTS class definition
%
%   Usage:
%      outputdefinition=outputdefinition();

classdef outputdefinition
	properties (SetAccess=public) 
		definitions                 = {};
	end
	methods
		function obj = outputdefinition(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{

			obj.definitions={};

		end % }}}
		function md = checkconsistency(obj,md,solution,analyses) % {{{

			md = checkfield(md,'outputdefinition.definitions','cell',1);

			for i=1:length(obj.definitions),
				md=checkconsistency(obj.definitions{i},md,solution,analyses);
			end

		end % }}}
		function disp(obj) % {{{
			disp(sprintf('   outputdefinition:'));
			fielddisplay(obj,'definitions','list of potential outputs that can be requested, but which need additional data to be defined');

		end % }}}
		function marshall(obj,md,fid) % {{{

		enums=zeros(length(obj.definitions),1);
		for i=1:length(obj.definitions),
			obj.definitions{i}.marshall(md,fid);
			classdefinition=class(obj.definitions{i});
			classdefinition(1)=upper(classdefinition(1)); %so it matches our enums definitions.
			enums(i)=StringToEnum(classdefinition);
		end
		enums=unique(enums);
		
		WriteData(fid,'data',enums,'enum',OutputdefinitionEnumsEnum(),'format','DoubleMat','mattype',1);
		end % }}}
	end
end
