from model import *
from triangle import *
from setmask import *
from parameterize import *
from setflowequation import *
from EnumDefinitions import *
from solve import *
from MatlabFuncs import *
from massfluxatgate import massfluxatgate

md=triangle(model(),'../Exp/Square.exp',50000)
md=setmask(md,'all','')
md=parameterize(md,'../Par/SquareShelfConstrained.py')
md=setflowequation(md,'SSA','all')
md.cluster=generic('name',oshostname(),'np',3)

#outputs
md.stressbalance.requested_outputs=['StressTensor','MassFlux1','MassFlux2','MassFlux3','MassFlux4','MassFlux5','MassFlux6']
md.outputdefinition.definitions=[
		massfluxatgate('MassFlux1',os.getcwd() + '/../Exp/MassFlux1.exp'),
		massfluxatgate('MassFlux2',os.getcwd() + '/../Exp/MassFlux2.exp'),
		massfluxatgate('MassFlux3',os.getcwd() + '/../Exp/MassFlux3.exp'),
		massfluxatgate('MassFlux4',os.getcwd() + '/../Exp/MassFlux4.exp'),
		massfluxatgate('MassFlux5',os.getcwd() + '/../Exp/MassFlux5.exp'),
		massfluxatgate('MassFlux6',os.getcwd() + '/../Exp/MassFlux6.exp')
		]

md=solve(md,StressbalanceSolutionEnum())

#Fields and tolerances to track changes
field_names     =['Vx','Vy','Vel','Pressure',\
	'StressTensorxx','StressTensoryy','StressTensorxy','MassFlux1','MassFlux2','MassFlux3','MassFlux4','MassFlux5','MassFlux6']
field_tolerances=[1e-13,1e-13,1e-13,1e-13,\
	1e-13,1e-13,1e-13,\
	1e-13, 1e-13, 1e-13, 1e-13, 1e-13, 1e-13 ]
field_values=[\
	md.results.StressbalanceSolution.Vx,\
	md.results.StressbalanceSolution.Vy,\
	md.results.StressbalanceSolution.Vel,\
	md.results.StressbalanceSolution.Pressure,\
	md.results.StressbalanceSolution.StressTensorxx,\
	md.results.StressbalanceSolution.StressTensoryy,\
	md.results.StressbalanceSolution.StressTensorxy,\
	md.results.StressbalanceSolution.MassFlux1,\
	md.results.StressbalanceSolution.MassFlux2,\
	md.results.StressbalanceSolution.MassFlux3,\
	md.results.StressbalanceSolution.MassFlux4,\
	md.results.StressbalanceSolution.MassFlux5,\
	md.results.StressbalanceSolution.MassFlux6 ]
