function [t_g ,m]=thermal_core(m,inputs)
%THERMAL_CORE - core of thermal solution sequence.
%   model is return together with temperature
%
%
%   Usage:
%      [t_g,m]=thermal_core(m,inputs)
%    
%      

	count=1;
	converged=0;

	%stiffness and load generation only:
	m.parameters.kflag=1; m.parameters.pflag=1;

	disp(sprintf('%s','   starting direct shooting method'));
	while(~converged),

		%Update inputs in datasets
		[m.elements,m.nodes, loads,m.materials]=UpdateFromInputs(m.elements,m.nodes, loads,m.materials,inputs);

		%system matrices 
		[K_gg_ , p_g_]=SystemMatrices(m.elements,m.nodes,loads,m.materials,m.parameters,inputs);

		%Reduce tangent matrix from g size to f size
		[K_ff, K_fs] = Reducematrixfromgtof( K_gg, m.Gmn, m.nodesets); 

		%Reduce load from g size to f size
		[p_f] = Reduceloadfromgtof( p_g, m.Gmn, K_fs, m.ys, m.nodesets);

		%Solve	
		if m.parameters.debug,
			disp(sprintf('%s%g','      condition number of stiffness matrix: ',condest(K_ff)));
		end
		[t_f]=Solver(K_ff,p_f,[],m.parameters);

		%Merge back to g set
		[t_g]= Mergesolutionfromftog( t_f, m.Gmn, m.ys, m.nodesets ); 

		%Update inputs in datasets
		inputs.temperature=t_g;
		[m.elements,m.nodes, loads,m.materials]=UpdateFromInputs(m.elements,m.nodes, loads,m.materials,inputs);
	
		%penalty constraints
		[m.loads,constraints_converged,num_unstable_constraints] =PenaltyConstraints( m.elements,m.nodes, m.loads, m.materials,m.parameters,inputs);
	
		if ~converged,
			if m.parameters.debug, disp(sprintf('   %s %i','#unstable constraints ',num_unstable_constraints));end;
			
			if num_unstable_constraints<thermalparams.min_thermal_constraints,
				converged=1;
			end
		end

		count=count+1;
	end

end
