function md=thermal(md)
%THERMAL - thermal solution sequence: steady state and transient
%
%   Usage:
%      md=thermal(md)

	%timing
	t1=clock;
	
	%md.analysis_type is set to thermalsteady or thermaltransient. save it.
	solutiontype=md.analysis_type;

	%Build all models requested for thermal and melting  simulation
	md.analysis_type=solutiontype; m_t=CreateFemModel(md); 
	md.analysis_type='melting' m_m=CreateFEMModel(md);

	% figure out number of dof: just for information purposes.
	md.dof=m_t.nodesets.fsize; %biggest dof number


	if strcmpi(solutiontype,'thermalsteady'),

		%initialize velocity and pressure 
		u_g=m_t.parameters.u_g;
		p_g=m_t.parameters.p_g;

		inputs=struct('pressure',p_g,'velocity',u_g);

		disp(sprintf('\n%s\n','computing temperature...'));
		[t_g,m_t]=thermal_core(m_t,inputs);

		disp(sprintf('\n%s\n','computing melting...'));
		inputs=struct('pressure',p_g,'temperature',t_g);
		
		melting_g=melting_core(m_m,inputs);

		%load results onto model
		md.temperature=t_g;
		md.melting=melting_g*md.yts; %from m/s to m/a

	else

		%initialize velocity, pressure  and temperature
		u_g=m.parameters.u_g;
		p_g=m.parameters.p_g;
		t_g=m.parameters.t_g;
		melting_g=m.parameters.melting_g;

		nsteps=m_t.parameters.ndt/m_t.parameters.dt;

		%initialize temperature and melting
		soln.t_g=t_g;
		soln.melting_g=melting_g;

		for n=1:nsteps, 

			disp(sprintf('\n%s%i/%i\n','time step: ',n,md.ndt/md.dt));
			disp('   computing temperature...');
		
			inputs=struct('pressure',p_g,'temperature',soln(n).t_g,'velocity',u_g,'dt',m_t.parameters.dt);
			[soln(n+1).t_g,m_t]=thermal_core(m_t,inputs);
			
			disp('   computing melting...');
			inputs=struct('pressure',p_g,'temperature',soln(n).t_g,'dt',m_t.parameters.dt);
			soln(n+1).melting_g=melting_core(m_m,inputs);
			
		end
		
		%Wrap up
		solution_temperature=struct('temperature',{});
		for n=1:nsteps+1,
			solution_temperature(n).temperature=soln(n).t_g;
		end
		md.temperature=solution_temperature;
		
		solution_melting=struct('melting',{});
		for n=1:nsteps+1,
			solution_melting(n).melting=soln(n).melting_g*md.yts; %in m/a
		end
		md.melting=solution_melting;
	end
	
