from fielddisplay import fielddisplay
from EnumDefinitions import *
from checkfield import *
from WriteData import *
from MeshProfileIntersection import *
import os

class massfluxatgate(object):
	"""
	MASSFLUXATEGATE class definition

	   Usage:
		  massfluxatgate=massfluxatgate('GateName','PathToExpFile')
	"""

	def __init__(self,name,profilename): # {{{
		self.name           = name
		self.profilename    = profilename
		self.segments       = float('NaN')

		#}}}
	def __repr__(self): # {{{

		string="   Massfluxatgate:"
		string="%s\n%s"%(string,fielddisplay(self,'name','identifier for this massfluxatgate response'))
		string="%s\n%s"%(string,fielddisplay(self,'profilename','name of file (shapefile or argus file) defining a profile (or gate)'))
		return string
		#}}}
	def setdefaultparameters(self): # {{{
		return self
	#}}}
	def checkconsistency(self,md,solution,analyses):    # {{{
		
		if  not isinstance(self.name, basestring):
			raise RuntimeError("massfluxatgate error message: 'name' field should be a string!")
			
		if  not isinstance(self.profilename, basestring):
			raise RuntimeError("massfluxatgate error message: 'profilename' field should be a string!") 
		
		#check the profilename points to a file!: 
		if not os.path.isfile(self.profilename):
			raise RuntimeError("massfluxatgate error message: file name for profile corresponding to gate does not point to a legitimate file on disk!")

		return md
	# }}}
	def marshall(self,md,fid):    # {{{
		
		#before marshalling, we need to create the segments out of the profilename: 
		self.segments=MeshProfileIntersection(md.mesh.elements,md.mesh.x,md.mesh.y,self.profilename)[0]

		#ok, marshall name and segments: 
		WriteData(fid,'object',self,'fieldname','name','format','String')
		WriteData(fid,'object',self,'fieldname','segments','format','DoubleMat','mattype',1)

	# }}}
