md=triangle(model(),'../Exp/Square.exp',50000.);
md=setmask(md,'all','');
md=parameterize(md,'../Par/SquareShelfConstrained.par');
md=setflowequation(md,'SSA','all');
md.cluster=generic('name',oshostname(),'np',2);
md.stressbalance.requested_outputs={'StressTensor','MassFlux1','MassFlux2','MassFlux3','MassFlux4','MassFlux5','MassFlux6'};
md=solve(md,StressbalanceSolutionEnum());

%Fields and tolerances to track changes
field_names     ={'Vx','Vy','Vel','Pressure',...
	'StressTensorxx','StressTensoryy','StressTensorxy','MassFlux1','MassFlux2','MassFlux3','MassFlux4','MassFlux5','MassFlux6'};
field_tolerances={1e-13,1e-13,1e-13,1e-13,...
	1e-13,1e-13,1e-13,...
	1e-13, 1e-13, 1e-13, 1e-13, 1e-13, 1e-13 };
field_values={...
	(md.results.StressbalanceSolution.Vx),...
	(md.results.StressbalanceSolution.Vy),...
	(md.results.StressbalanceSolution.Vel),...
	(md.results.StressbalanceSolution.Pressure),...
	(md.results.StressbalanceSolution.StressTensorxx),...
	(md.results.StressbalanceSolution.StressTensoryy),...
	(md.results.StressbalanceSolution.StressTensorxy),...
	(md.results.StressbalanceSolution.MassFlux1),...
	(md.results.StressbalanceSolution.MassFlux2),...
	(md.results.StressbalanceSolution.MassFlux3),...
	(md.results.StressbalanceSolution.MassFlux4),...
	(md.results.StressbalanceSolution.MassFlux5),...
	(md.results.StressbalanceSolution.MassFlux6)...
	};
