/*!\file: CreateParametersOutputDefinitions.cpp
 * \brief driver for creating output definitions dataset, and including it into the parameters dataset
 */ 

#include "../../toolkits/toolkits.h"
#include "../../classes/classes.h"
#include "../../shared/shared.h"
#include "./ModelProcessorx.h"

void CreateOutputDefinitions(Parameters** pparameters,IoModel* iomodel){

	int i,j;
	
	Parameters *parameters = NULL;
	DataSet* output_definitions=NULL;
	int*     output_definition_enums;
	int      num_output_definitions;
	int      numgates;
	char**   gatenames=NULL;
	IssmDouble** gatesegments=NULL;
	int*         gatesegments_M=NULL;

	/*Get parameters: */
	parameters=*pparameters;

	/*Create output_definitions dataset: */
	output_definitions=new DataSet();
	
	iomodel->FetchData(&output_definition_enums,&num_output_definitions,NULL,OutputdefinitionEnumsEnum); 
	if(num_output_definitions){
		for (i=0;i<num_output_definitions;i++){

			if (output_definition_enums[i]==MassfluxatgateEnum){
				/*Deal with mass flux gates:{{{ */

				/*Fetch segments and names: */
				iomodel->FetchMultipleData(&gatenames,&numgates,MassfluxatgateNameEnum);
				iomodel->FetchMultipleData(&gatesegments,&gatesegments_M,NULL,&numgates,MassfluxatgateSegmentsEnum);

				for(j=0;j<numgates;j++){
					output_definitions->AddObject(new Massfluxatgate<IssmDouble>(gatenames[j],gatesegments_M[j],gatesegments[j]));
				}
				/*Free ressources:*/
				for(j=0;j<numgates;j++){
					char* string=gatenames[j]; xDelete<char>(string);
					IssmDouble* gate=gatesegments[j]; xDelete<IssmDouble>(gate);
				}
				xDelete<char*>(gatenames);
				xDelete<IssmDouble*>(gatesegments);
				xDelete<int>(gatesegments_M);
				/*}}}*/
			}
			else _error_("output definition enum " << output_definition_enums[i] << "not supported yet!");
		}
	}
	parameters->AddObject(new DataSetParam(OutputdefinitionEnum,output_definitions));

	/*Free ressources:*/
	delete output_definitions;
	xDelete<int>(output_definition_enums);

	/*Assign output pointer: */
	*pparameters=parameters;
}
