import numpy
from fielddisplay import fielddisplay
from EnumDefinitions import *
from checkfield import *
from WriteData import *

class steadystate(object):
	"""
	STEADYSTATE class definition

	   Usage:
	      steadystate=steadystate();
	"""

	def __init__(self): # {{{
		self.reltol            = 0
		self.maxiter           = 0
		self.requested_outputs = []

		#set defaults
		self.setdefaultparameters()

		#}}}
	def __repr__(self): # {{{
		string='   steadystate solution parameters:'
		string="%s\n%s"%(string,fielddisplay(self,'reltol','relative tolerance criterion'))
		string="%s\n%s"%(string,fielddisplay(self,'maxiter','maximum number of iterations'))
		string="%s\n%s"%(string,fielddisplay(self,'requested_outputs','additional requested outputs'))
		return string
		#}}}
	def setdefaultparameters(self): # {{{
		
		#maximum of steady state iterations
		self.maxiter=100

		#Relative tolerance for the steadystate convertgence
		self.reltol=0.01

		return self
	#}}}
	def checkconsistency(self,md,solution,analyses):    # {{{

		#Early return
		if not solution==SteadystateSolutionEnum():
			return md

		if not md.timestepping.time_step==0:
			md.checkmessage("for a steadystate computation, timestepping.time_step must be zero.")

		if numpy.isnan(md.stressbalance.reltol):
			md.checkmessage("for a steadystate computation, stressbalance.reltol (relative convergence criterion) must be defined!")

		if md.steadystate.requested_outputs:
			md = checkfield(md,'steadystate.requested_outputs','cell',1)

		return md
	# }}}
	def marshall(self,md,fid):    # {{{
		WriteData(fid,'object',self,'fieldname','reltol','format','Double')
		WriteData(fid,'object',self,'fieldname','maxiter','format','Integer')
		WriteData(fid,'object',self,'fieldname','requested_outputs','format','StringArray')
	# }}}
