from fielddisplay import fielddisplay
from EnumDefinitions import *
from StringToEnum import StringToEnum
from checkfield import *
from WriteData import *
import numpy as npy

class outputdefinition(object):
	"""
	OUTPUTDEFINITION class definition

	   Usage:
	      outputdefinition=outputdefinition();
	"""

	def __init__(self): # {{{
		self.definitions                   = []
		self.enums                         = float('NaN')
		#}}}
	def __repr__(self): # {{{
		string="   Outputdefinitions:"

		string="%s\n%s"%(string,fielddisplay(self,"definitions","list of potential outputs that can be requested, but which need additional data to be defined"))

		return string
		#}}}
	def setdefaultparameters(self): # {{{
		return self
		#}}}
	def checkconsistency(self,md,solution,analyses):    # {{{
		
		md = checkfield(md,'outputdefinition.definitions','cell',1)
		for definition in self.definitions:
			definition.checkconsistency(md,solution,analyses);

	# }}}
	def marshall(self,md,fid):    # {{{
		
		self.enums=npy.zeros(len(self.definitions),)
		
		for i in range(len(self.definitions)):
			self.definitions[i].marshall(md,fid);
			classdefinition=self.definitions[i].__class__.__name__
			classdefinition=classdefinition[0].upper()+classdefinition[1:]
			self.enums[i]=StringToEnum(classdefinition)[0]
		
		self.enums=npy.unique(self.enums);
		
		WriteData(fid,'object',self,'fieldname','enums','format','DoubleMat','mattype',1)

	# }}}
