%CONSTANTS class definition
%
%   Usage:
%      outputdefinition=outputdefinition();

classdef outputdefinition
	properties (SetAccess=public) 
		definitions                 = {};
	end
	properties (SetAccess=private) 
		enums                 = {};
	end
	methods
		function obj = outputdefinition(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{

			obj.definitions={};
			obj.enums=NaN;

		end % }}}
		function md = checkconsistency(obj,md,solution,analyses) % {{{

			md = checkfield(md,'outputdefinition.definitions','cell',1);

			for i=1:length(obj.definitions),
				md=checkconsistency(obj.definitions{i},md,solution,analyses);
			end

		end % }}}
		function disp(obj) % {{{
			disp(sprintf('   outputdefinition:'));
			fielddisplay(obj,'definitions','list of potential outputs that can be requested, but which need additional data to be defined');

		end % }}}
		function marshall(obj,md,fid) % {{{

		enums=zeros(length(obj.definitions),1);
		for i=1:length(obj.definitions),
			obj.definitions{i}.marshall(md,fid);
			classdefinition=class(obj.definitions{i});
			classdefinition(1)=upper(classdefinition(1)); %so it matches our enums definitions.
			obj.enums(i)=StringToEnum(classdefinition);
		end
		obj.enums=unique(obj.enums);
		
		WriteData(fid,'object',obj,'fieldname','enums','format','DoubleMat','mattype',1);
		end % }}}
	end
end
