from fielddisplay import fielddisplay
from EnumDefinitions import *
from checkfield import *
from WriteData import *

class transient(object):
	"""
	TRANSIENT class definition

	   Usage:
	      transient=transient();
	"""

	def __init__(self): # {{{
		self.ismasstransport      = False
		self.isstressbalance      = False
		self.isthermal         = False
		self.isgroundingline   = False
		self.isgia             = False
		self.requested_outputs = []

		#set defaults
		self.setdefaultparameters()

		#}}}
	def __repr__(self): # {{{
		string='   transient solution parameters:'
		string="%s\n%s"%(string,fielddisplay(self,'ismasstransport','indicates if a masstransport solution is used in the transient'))
		string="%s\n%s"%(string,fielddisplay(self,'isstressbalance','indicates if a stressbalance solution is used in the transient'))
		string="%s\n%s"%(string,fielddisplay(self,'isthermal','indicates if a thermal solution is used in the transient'))
		string="%s\n%s"%(string,fielddisplay(self,'isgroundingline','indicates if a groundingline migration is used in the transient'))
		string="%s\n%s"%(string,fielddisplay(self,'isgia','indicates if a postglacial rebound is used in the transient'))
		string="%s\n%s"%(string,fielddisplay(self,'requested_outputs','list of additional outputs requested'))
		return string
		#}}}
	def setdefaultparameters(self): # {{{
		
		#full analysis: Stressbalance, Masstransport and Thermal but no groundingline migration for now
		self.ismasstransport=True
		self.isstressbalance=True
		self.isthermal=True
		self.isgroundingline=False
		self.isgia=False

		return self
	#}}}
	def checkconsistency(self,md,solution,analyses):    # {{{

		#Early return
		if not solution==TransientSolutionEnum():
			return md

		md = checkfield(md,'transient.ismasstransport','numel',[1],'values',[0,1])
		md = checkfield(md,'transient.isstressbalance','numel',[1],'values',[0,1])
		md = checkfield(md,'transient.isthermal','numel',[1],'values',[0,1])
		md = checkfield(md,'transient.isgroundingline','numel',[1],'values',[0,1])
		md = checkfield(md,'transient.isgia','numel',[1],'values',[0,1])
		if md.transient.requested_outputs:
			md = checkfield(md,'transient.requested_outputs','size',[1, float('NaN')])


		return md
	# }}}
	def marshall(self,md,fid):    # {{{
		WriteData(fid,'object',self,'fieldname','ismasstransport','format','Boolean')
		WriteData(fid,'object',self,'fieldname','isstressbalance','format','Boolean')
		WriteData(fid,'object',self,'fieldname','isthermal','format','Boolean')
		WriteData(fid,'object',self,'fieldname','isgroundingline','format','Boolean')
		WriteData(fid,'object',self,'fieldname','isgia','format','Boolean')
		WriteData(fid,'object',self,'fieldname','requested_outputs','format','StringArray')
	# }}}

