#ifndef _CONTAINER_INPUTS_H_
#define _CONTAINER_INPUTS_H_

/*forward declarations */
class Parameters;
class Input;

#include "../../datastructures/datastructures.h"
#include "../../shared/shared.h"

/*! \brief Declaration of Inputs class.
 *
 * Declaration of Inputs class.  Inputs are vector lists (Containers) of Input objects.
 */ 
class Inputs: public DataSet{

	public:

		/*constructors, destructors*/
		Inputs();
		~Inputs();

		/*numerics*/
		int         AddInput(Input* in_input);
		void        ChangeEnum(int enumtype,int new_enumtype);
		void        ConstrainMin(int constrain_enum, IssmDouble minimum);
		int         DeleteInput(int enum_type);
		void        DuplicateInput(int original_enum,int new_enum);
		Input*      GetInput(int enum_name);
		Inputs*     SpawnTriaInputs(int position);
		Inputs*     SpawnSegInputs(int index1,int index2);
		Inputs*     SpawnSegInputs(int position);
		void        AXPY(int inputy_enum, IssmDouble scalar, int inputx_enum);
		IssmDouble  InfinityNorm(int enumtype);
		IssmDouble  Max(int enumtype);
		IssmDouble  MaxAbs(int enumtype);
		IssmDouble  Min(int enumtype);
		IssmDouble  MinAbs(int enumtype);
		void        GetInputAverage(IssmDouble* pvalue, int enum_type);
		void        GetInputValue(bool* pvalue,int enum_type);
		void        GetInputValue(int* pvalue,int enum_type);
		void        GetInputValue(IssmDouble* pvalue,int enum_type);
		void        Configure(Parameters* parameters);

};

#endif //ifndef _INPUTS_H_
