/*!\file Seg.cpp
 * \brief: implementation of the Segment object
 */
/*Headers:*/
/*{{{*/
#ifdef HAVE_CONFIG_H
#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../classes.h"
#include "../../shared/shared.h"
/*}}}*/

/*Element macros*/
#define NUMVERTICES 2
/*Constructors/destructor/copy*/
/*FUNCTION Seg::Seg(){{{*/
Seg::Seg(){
	this->nodes      = NULL;
	this->vertices   = NULL;
	this->material   = NULL;
	this->matpar     = NULL;
	this->inputs     = NULL;
	this->parameters = NULL;
	this->results    = NULL;
}
/*}}}*/
/*FUNCTION Seg::Seg(int id, int sid,int index, IoModel* iomodel,int nummodels){{{*/
Seg::Seg(int seg_id, int seg_sid, int index, IoModel* iomodel,int nummodels)
		:SegRef(nummodels),ElementHook(nummodels,index+1,2,iomodel){

			/*id: */
			this->id  = seg_id;
			this->sid = seg_sid;

			//this->parameters: we still can't point to it, it may not even exist. Configure will handle this.
			this->parameters = NULL;

			/*intialize inputs and results: */
			this->inputs  = new Inputs();
			this->results = new Results();

			/*initialize pointers:*/
			this->nodes    = NULL;
			this->vertices = NULL;
			this->material = NULL;
			this->matpar   = NULL;

		}
/*}}}*/
/*FUNCTION Seg::~Seg(){{{*/
Seg::~Seg(){
	delete inputs;
	delete results;
	this->parameters=NULL;
}
/*}}}*/
/*FUNCTION Seg::copy {{{*/
Object* Seg::copy() {
	_error_("not implemented yet");
}
/*}}}*/

/*FUNCTION Seg::Echo{{{*/
void Seg::Echo(void){
	_printf_("Seg:\n");
	_printf_("   id: " << id << "\n");
	if(nodes){
		nodes[0]->Echo();
		nodes[1]->Echo();
	}
	else _printf_("nodes = NULL\n");

	if (material) material->Echo();
	else _printf_("material = NULL\n");

	if (matpar) matpar->Echo();
	else _printf_("matpar = NULL\n");

	_printf_("   parameters\n");
	if (parameters) parameters->Echo();
	else _printf_("parameters = NULL\n");

	_printf_("   inputs\n");
	if (inputs) inputs->Echo();
	else _printf_("inputs=NULL\n");

	if (results) results->Echo();
	else _printf_("results=NULL\n");
}
/*}}}*/
/*FUNCTION Seg::DeepEcho{{{*/
void Seg::DeepEcho(void){

	_printf_("Seg:\n");
	_printf_("   id: " << id << "\n");
	if(nodes){
		nodes[0]->DeepEcho();
		nodes[1]->DeepEcho();
	}
	else _printf_("nodes = NULL\n");

	if (material) material->DeepEcho();
	else _printf_("material = NULL\n");

	if (matpar) matpar->DeepEcho();
	else _printf_("matpar = NULL\n");

	_printf_("   parameters\n");
	if (parameters) parameters->DeepEcho();
	else _printf_("parameters = NULL\n");

	_printf_("   inputs\n");
	if (inputs) inputs->DeepEcho();
	else _printf_("inputs=NULL\n");

	if (results) results->DeepEcho();
	else _printf_("results=NULL\n");

	return;
}
/*}}}*/
/*FUNCTION Seg::ObjectEnum{{{*/
int Seg::ObjectEnum(void){

	return SegEnum;

}
/*}}}*/
/*FUNCTION Seg::Id {{{*/
int    Seg::Id(){

	return id;

}
/*}}}*/

/*FUNCTION Seg::CreateMassMatrix {{{*/
ElementMatrix* Seg::CreateMassMatrix(void){

	/* Intermediaries */
	IssmDouble  D,Jdet;
	IssmDouble  xyz_list[NUMVERTICES][2];

	/*Fetch number of nodes and dof for this finite element*/
	int numnodes = this->NumberofNodes();

	/*Initialize Element matrix and vectors*/
	ElementMatrix* Ke    = new ElementMatrix(nodes,numnodes,this->parameters,NoneApproximationEnum);
	IssmDouble*    basis = xNew<IssmDouble>(numnodes);

	/*Retrieve all inputs and parameters*/
	GetVerticesCoordinates(&xyz_list[0][0],vertices,NUMVERTICES);

	/* Start looping on the number of gaussian points: */
	GaussSeg* gauss=new GaussSeg(2);
	for(int ig=gauss->begin();ig<gauss->end();ig++){

		gauss->GaussPoint(ig);

		GetNodalFunctions(basis,gauss);
		GetJacobianDeterminant(&Jdet, &xyz_list[0][0],gauss);
		D=gauss->weight*Jdet;

		TripleMultiply(basis,1,numnodes,1,
					&D,1,1,0,
					basis,1,numnodes,0,
					&Ke->values[0],1);
	}

	/*Clean up and return*/
	delete gauss;
	xDelete<IssmDouble>(basis);
	return Ke;
}
/*}}}*/
/*FUNCTION Seg::CreatePVectorSlope {{{*/
ElementVector* Seg::CreatePVectorSlope(void){

	/*Intermediaries */
	int        i,analysis_type;
	IssmDouble Jdet;
	IssmDouble xyz_list[NUMVERTICES][2];
	IssmDouble slope;

	/*Fetch number of nodes and dof for this finite element*/
	int numnodes = this->NumberofNodes();

	/*Initialize Element vector*/
	ElementVector* pe    = new ElementVector(nodes,numnodes,this->parameters);
	IssmDouble*    basis = xNew<IssmDouble>(numnodes);

	/*Retrieve all inputs and parameters*/
	parameters->FindParam(&analysis_type,AnalysisTypeEnum);
	GetVerticesCoordinates(&xyz_list[0][0],vertices,NUMVERTICES);
	Input* slope_input=NULL;
	if(analysis_type==SurfaceSlopeXAnalysisEnum){
		slope_input=inputs->GetInput(SurfaceEnum); _assert_(slope_input);
	}
	else if(analysis_type==BedSlopeXAnalysisEnum){
		slope_input=inputs->GetInput(BedEnum);     _assert_(slope_input);
	}
	else{
		_error_("Analysis "<<EnumToStringx(analysis_type)<<" not inplemented yet");
	}

	/* Start  looping on the number of gaussian points: */
	GaussSeg* gauss=new GaussSeg(2);
	for(int ig=gauss->begin();ig<gauss->end();ig++){

		gauss->GaussPoint(ig);

		GetJacobianDeterminant(&Jdet, &xyz_list[0][0],gauss);
		GetNodalFunctions(basis,gauss);

		slope_input->GetInputDerivativeValue(&slope,&xyz_list[0][0],gauss);

		for(i=0;i<numnodes;i++) pe->values[i]+=Jdet*gauss->weight*slope*basis[i];
	}

	/*Clean up and return*/
	xDelete<IssmDouble>(basis);
	delete gauss;
	return pe;
}
/*}}}*/
