/*!\file SegRef.c
 * \brief: implementation of the SegRef object
 */

/*Headers:*/
/*{{{*/
#ifdef HAVE_CONFIG_H
#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../classes.h"
#include "../../shared/shared.h"
/*}}}*/

/*Element macros*/
#define NUMNODESP1  2

/*Object constructors and destructor*/
/*FUNCTION SegRef::SegRef(){{{*/
SegRef::SegRef(){
	this->element_type_list=NULL;
}
/*}}}*/
/*FUNCTION SegRef::SegRef(int* types,int nummodels){{{*/
SegRef::SegRef(const int nummodels){

	/*Only allocate pointer*/
	element_type_list=xNew<int>(nummodels);

}
/*}}}*/
/*FUNCTION SegRef::~SegRef(){{{*/
SegRef::~SegRef(){
	xDelete<int>(element_type_list);
}
/*}}}*/

/*Management*/
/*FUNCTION SegRef::SetElementType{{{*/
void SegRef::SetElementType(int type,int type_counter){

	/*initialize element type*/
	this->element_type_list[type_counter]=type;
}
/*}}}*/

/*Reference Element numerics*/
/*FUNCTION SegRef::GetNodalFunctions{{{*/
void SegRef::GetNodalFunctions(IssmDouble* basis,GaussSeg* gauss){
	/*This routine returns the values of the nodal functions  at the gaussian point.*/

	_assert_(basis);

	switch(this->element_type){
		case P1Enum: case P1DGEnum:
			basis[0]=(1.-gauss->coord1)/2.;
			basis[1]=(1.+gauss->coord1)/2.;
			return;
		default:
			_error_("Element type "<<EnumToStringx(this->element_type)<<" not supported yet");
	}
}
/*}}}*/
/*FUNCTION SegRef::GetJacobian{{{*/
void SegRef::GetJacobian(IssmDouble* J, IssmDouble* xyz_list,GaussSeg* gauss){
	/*The Jacobian is constant over the element, discard the gaussian points. 
	 * J is assumed to have been allocated of size 1*/

	IssmDouble x1=xyz_list[3*0+0];
	IssmDouble y1=xyz_list[3*0+1];
	IssmDouble z1=xyz_list[3*0+2];
	IssmDouble x2=xyz_list[3*1+0];
	IssmDouble y2=xyz_list[3*1+1];
	IssmDouble z2=xyz_list[3*1+2];

	*Jdet=.5*sqrt(pow(x2-x1,2) + pow(y2-y1,2) + pow(z2-z1,2));
	if(*Jdet<0) _error_("negative jacobian determinant!");
}
/*}}}*/
/*FUNCTION SegRef::GetJacobianDeterminant{{{*/
void SegRef::GetJacobianDeterminant(IssmDouble*  Jdet, IssmDouble* xyz_list,GaussSeg* gauss){
	/*The Jacobian determinant is constant over the element, discard the gaussian points. 
	 * J is assumed to have been allocated of size NDOF2xNDOF2.*/

	/*Call Jacobian routine to get the jacobian:*/
	GetJacobian(&Jdet, xyz_list, gauss);

}
/*}}}*/
/*FUNCTION SegRef::GetJacobianInvert {{{*/
void SegRef::GetJacobianInvert(IssmDouble* Jinv, IssmDouble* xyz_list,GaussSeg* gauss){

	/*Jacobian*/
	IssmDouble J;

	/*Call Jacobian routine to get the jacobian:*/
	GetJacobian(&J, xyz_list, gauss);

	/*Invert Jacobian matrix: */
	*Jinv = 1./J;
}
/*}}}*/
