%TRANSIENT class definition
%
%   Usage:
%      transient=transient();

classdef transient
	properties (SetAccess=public) 
		ismasstransport      = 0;
		isstressbalance      = 0;
		isthermal         = 0;
		isgroundingline   = 0;
		isgia             = 0;
		isdamage             = 0;
		requested_outputs = {};
	end
	methods
		function obj = transient(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{

			%full analysis: Stressbalance, Masstransport and Thermal but no groundingline migration for now
			obj.ismasstransport=1;
			obj.isstressbalance=1;
			obj.isthermal=1;
			obj.isgroundingline=0;
			obj.isgia=0;
			obj.isdamage=0;

		end % }}}
		function md = checkconsistency(obj,md,solution,analyses) % {{{

			%Early return
			if solution~=TransientSolutionEnum(), return; end

			md = checkfield(md,'transient.ismasstransport','numel',[1],'values',[0 1]);
			md = checkfield(md,'transient.isstressbalance','numel',[1],'values',[0 1]);
			md = checkfield(md,'transient.isthermal','numel',[1],'values',[0 1]);
			md = checkfield(md,'transient.isgroundingline','numel',[1],'values',[0 1]);
			md = checkfield(md,'transient.isgia','numel',[1],'values',[0 1]);
			md = checkfield(md,'transient.isdamage','numel',[1],'values',[0 1]);
			md = checkfield(md,'transient.requested_outputs','size',[1 NaN]);

		end % }}}
		function disp(obj) % {{{
			disp(sprintf('   transient solution parameters:'));

			fielddisplay(obj,'ismasstransport','indicates whether a masstransport solution is used in the transient');
			fielddisplay(obj,'isstressbalance','indicates whether a stressbalance solution is used in the transient');
			fielddisplay(obj,'isthermal','indicates whether a thermal solution is used in the transient');
			fielddisplay(obj,'isgroundingline','indicates whether a groundingline migration is used in the transient');
			fielddisplay(obj,'isgia','indicates whether a postglacial rebound model is used in the transient');
			fielddisplay(obj,'isdamage','indicates whether damage evolution is used in the transient');
			fielddisplay(obj,'requested_outputs','list of additional outputs requested');

		end % }}}
		function marshall(obj,md,fid) % {{{
			WriteData(fid,'object',obj,'fieldname','ismasstransport','format','Boolean');
			WriteData(fid,'object',obj,'fieldname','isstressbalance','format','Boolean');
			WriteData(fid,'object',obj,'fieldname','isthermal','format','Boolean');
			WriteData(fid,'object',obj,'fieldname','isgroundingline','format','Boolean');
			WriteData(fid,'object',obj,'fieldname','isgia','format','Boolean');
			WriteData(fid,'object',obj,'fieldname','isdamage','format','Boolean');
			WriteData(fid,'object',obj,'fieldname','requested_outputs','format','StringArray');
		end % }}}
	end
end
